/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.shell;

import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.shell.ShellAnalysisJobBase;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.util.Exceptions;
import java.util.LinkedList;

public class ShellAnalysisJob
extends ShellAnalysisJobBase {
    public static ShellParameterSecurityPolicy SHELL_PARAMETER_SECURITY_POLICY = new ShellParameterSecurityPolicy();
    private static final String USE_ONLY_PARAMETER_VALUE_TOKEN = "-value-only";
    private static final String NO_PARAMETER_VALUE_TOKEN = "NO-VALUE";

    @Override
    protected void preExecute() throws JobCancelledException {
        LinkedList<String> inputParameters;
        this.cancelCheck();
        super.preExecute();
        String executablePath = this.analysis.getCommand();
        this.useStdout = this.analysis.getConfigParameters().get("stdout") != null && this.analysis.getConfigParameters().get("stdout").toLowerCase().equals("yes");
        boolean inputLast = this.analysis.getConfigParameters().get("input") != null && this.analysis.getConfigParameters().get("input").toLowerCase().equals("last");
        boolean noInput = this.analysis.getConfigParameters().get("input") != null && this.analysis.getConfigParameters().get("input").toLowerCase().equals("none");
        boolean inputsAsPlainArguments = this.analysis.getConfigParameters().get("inputs-as-plain-arguments") != null && this.analysis.getConfigParameters().get("inputs-as-plain-arguments").toLowerCase().equals("true");
        String arguments = this.analysis.getConfigParameters().get("arguments");
        String[] extraArguments = arguments != null && !arguments.equals("") ? arguments.trim().split(" ") : new String[]{};
        String outputParameter = null;
        if (!this.useStdout.booleanValue()) {
            outputParameter = this.analysis.getConfigParameters().get("output");
        }
        try {
            inputParameters = new LinkedList<String>(this.inputMessage.getParameters(SHELL_PARAMETER_SECURITY_POLICY, this.analysis));
        }
        catch (JobMessage.ParameterValidityException e) {
            this.outputMessage.setErrorMessage(e.getMessage());
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED_USER_ERROR, "");
            return;
        }
        LinkedList<String> commandParts = new LinkedList<String>();
        commandParts.add(executablePath);
        if (inputsAsPlainArguments) {
            for (ToolDescription.InputDescription input : this.analysis.getInputFiles()) {
                commandParts.add(input.getFileName());
            }
        }
        for (String arg : extraArguments) {
            commandParts.add(arg);
        }
        int index = 0;
        for (ToolDescription.ParameterDescription parameter : this.analysis.getParameters()) {
            String value = inputParameters.get(index);
            if (parameter.getName().endsWith(USE_ONLY_PARAMETER_VALUE_TOKEN)) {
                if (!value.equals(NO_PARAMETER_VALUE_TOKEN)) {
                    commandParts.add(value);
                }
            } else if (!value.equals("")) {
                commandParts.add("-" + parameter.getName());
                commandParts.add(value);
            }
            ++index;
        }
        if (outputParameter != null) {
            ToolDescription.OutputDescription output = this.analysis.getOutputFiles().get(0);
            commandParts.add("-" + outputParameter);
            commandParts.add(output.getFileName().getID());
        }
        if (!inputsAsPlainArguments && !noInput) {
            for (ToolDescription.InputDescription input : this.analysis.getInputFiles()) {
                if (!inputLast) {
                    commandParts.add("-" + input.getFileName());
                }
                commandParts.add(input.getFileName());
            }
        }
        this.command = commandParts.toArray(new String[0]);
    }

    public static class ShellParameterSecurityPolicy
    implements JobMessage.ParameterSecurityPolicy {
        private static final int MAX_VALUE_LENGTH = 1000;
        public static String COMMAND_LINE_SAFE_VALUE_PATTERN = "[\\w+\\-_:\\.,*()= ]*";

        @Override
        public boolean isValueValid(String value, ToolDescription.ParameterDescription parameterDescription) {
            if (value.length() > 1000) {
                return false;
            }
            if (value.contains("\"")) {
                return false;
            }
            return value.matches(COMMAND_LINE_SAFE_VALUE_PATTERN);
        }
    }
}

