/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.emboss.jemboss.gui.ColumnData;
import org.emboss.jemboss.gui.SequenceData;

class SequenceListTableModel
extends AbstractTableModel {
    protected static Vector modelVector;
    public static final int COL_NAME = 0;
    public static final int COL_BEG = 1;
    public static final int COL_END = 2;
    public static final int COL_LIST = 3;
    public static final int COL_DEF = 4;
    public static final ColumnData[] modelColumns;

    public SequenceListTableModel() {
        modelVector = new Vector();
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jembossSeqList");
        this.setDefaultData();
        if (file.canRead()) {
            this.loadStoredSeqList(file);
        }
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    protected void loadStoredSeqList(File file) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals("")) continue;
                string = string.trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                for (int i = 0; i < this.getColumnCount() && stringTokenizer.hasMoreTokens(); ++i) {
                    Object object;
                    if (n >= this.getRowCount()) {
                        object = new Boolean(false);
                        modelVector.addElement(new SequenceData("", "", "", (Boolean)object, (Boolean)object, (Boolean)object));
                    }
                    if (((String)(object = stringTokenizer.nextToken())).equals("-")) {
                        object = "";
                    }
                    if (((String)object).equalsIgnoreCase("true") || ((String)object).equalsIgnoreCase("false")) {
                        this.setValueAt(new Boolean((String)object), n, i);
                        continue;
                    }
                    this.setValueAt(object, n, i);
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("ArrayIndexOutOfBoundsException in SequenceList");
            this.setDefaultData();
        }
        catch (IOException iOException) {
            this.setDefaultData();
        }
    }

    protected void setDefaultData() {
        modelVector.removeAllElements();
        Boolean bl = new Boolean(false);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            modelVector.addElement(new SequenceData("", "", "", bl, bl, bl));
        }
    }

    protected SequenceData getSequenceData(int n) {
        return (SequenceData)modelVector.get(n);
    }

    public int getRowCount() {
        return modelVector == null ? 0 : modelVector.size();
    }

    public int getColumnCount() {
        return modelColumns.length;
    }

    public String getColumnName(int n) {
        return SequenceListTableModel.modelColumns[n].title;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n2 >= this.getRowCount()) {
            return "";
        }
        SequenceData sequenceData = (SequenceData)modelVector.elementAt(n);
        switch (n2) {
            case 0: {
                return sequenceData.s_name;
            }
            case 1: {
                return sequenceData.s_beg;
            }
            case 2: {
                return sequenceData.s_end;
            }
            case 4: {
                return sequenceData.s_default;
            }
            case 3: {
                return sequenceData.s_listFile;
            }
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < 0 || n2 >= this.getRowCount()) {
            return;
        }
        SequenceData sequenceData = (SequenceData)modelVector.elementAt(n);
        String string = object.toString();
        switch (n2) {
            case 0: {
                sequenceData.s_name = string;
                break;
            }
            case 1: {
                sequenceData.s_beg = string;
                break;
            }
            case 2: {
                sequenceData.s_end = string;
                break;
            }
            case 4: {
                sequenceData.s_default = (Boolean)object;
                break;
            }
            case 3: {
                sequenceData.s_listFile = (Boolean)object;
            }
        }
    }

    public void insertRow(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > modelVector.size()) {
            n = modelVector.size();
        }
        modelVector.insertElementAt(new SequenceData(), n);
    }

    public boolean deleteRow(int n) {
        if (n < 0 || n >= modelVector.size()) {
            return false;
        }
        modelVector.remove(n);
        if (this.getRowCount() < this.getColumnCount()) {
            Boolean bl = new Boolean(false);
            modelVector.addElement(new SequenceData("", "", "", bl, bl, bl));
        }
        return true;
    }

    static {
        modelColumns = new ColumnData[]{new ColumnData("File / Database Entry", 170, 2), new ColumnData("Start", 45, 2), new ColumnData("End", 45, 2), new ColumnData("List File", 15, 2), new ColumnData("Default", 15, 2)};
    }
}

