/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractHandlerExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Set mappedHandlers;
    private Class[] mappedHandlerClasses;
    private Log warnLogger;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setMappedHandlers(Set mappedHandlers) {
        this.mappedHandlers = mappedHandlers;
    }

    public void setMappedHandlerClasses(Class[] mappedHandlerClasses) {
        this.mappedHandlerClasses = mappedHandlerClasses;
    }

    public void setWarnLogCategory(String loggerName) {
        this.warnLogger = LogFactory.getLog((String)loggerName);
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.shouldApplyTo(request, handler)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolving exception from handler [" + handler + "]: " + ex));
            }
            this.logException(ex, request);
            return this.doResolveException(request, response, handler, ex);
        }
        return null;
    }

    protected boolean shouldApplyTo(HttpServletRequest request, Object handler) {
        if (handler != null) {
            if (this.mappedHandlers != null && this.mappedHandlers.contains(handler)) {
                return true;
            }
            if (this.mappedHandlerClasses != null) {
                Class[] classArray = this.mappedHandlerClasses;
                int n = this.mappedHandlerClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class handlerClass = classArray[n2];
                    if (handlerClass.isInstance(handler)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return this.mappedHandlers == null && this.mappedHandlerClasses == null;
    }

    protected void logException(Exception ex, HttpServletRequest request) {
        if (this.warnLogger != null && this.warnLogger.isWarnEnabled()) {
            this.warnLogger.warn((Object)this.buildLogMessage(ex, request), (Throwable)ex);
        }
    }

    protected String buildLogMessage(Exception ex, HttpServletRequest request) {
        return "Handler execution resulted in exception";
    }

    protected abstract ModelAndView doResolveException(HttpServletRequest var1, HttpServletResponse var2, Object var3, Exception var4);
}

