/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.BuildProgramMenu;
import org.emboss.jemboss.gui.DragJTable;
import org.emboss.jemboss.gui.SequenceData;
import org.emboss.jemboss.gui.SequenceListTableModel;
import org.emboss.jemboss.gui.filetree.DragTree;
import org.emboss.jemboss.gui.filetree.RemoteDragTree;
import org.emboss.jemboss.parser.Ajax;
import org.emboss.jemboss.parser.AjaxUtil;
import org.emboss.jemboss.programs.RunEmbossApplication2;
import org.emboss.jemboss.soap.AuthPopup;
import org.emboss.jemboss.soap.CallAjax;
import org.emboss.jemboss.soap.JembossSoapException;

public class SequenceList
extends JFrame {
    private DragJTable table;
    private SequenceListTableModel seqModel;
    private JCheckBoxMenuItem storeSeqList;
    final Cursor cbusy = new Cursor(3);
    final Cursor cdone = new Cursor(0);

    public SequenceList(final boolean bl, final JembossParams jembossParams) {
        super("Sequence List");
        Serializable serializable;
        this.setSize(400, 155);
        this.seqModel = new SequenceListTableModel();
        this.table = new DragJTable(this.seqModel);
        this.table.setModel(this.seqModel);
        this.table.setSelectionMode(0);
        for (int i = 0; i < SequenceListTableModel.modelColumns.length; ++i) {
            serializable = this.table.getColumn(SequenceListTableModel.modelColumns[i].title);
            ((TableColumn)serializable).setPreferredWidth(SequenceListTableModel.modelColumns[i].width);
        }
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setSize(300, 100);
        this.getContentPane().add((Component)jScrollPane, "Center");
        serializable = new JMenuBar();
        new BoxLayout((Container)serializable, 0);
        this.setJMenuBar((JMenuBar)serializable);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        ((JMenuBar)serializable).add(jMenu);
        JMenu jMenu2 = new JMenu("Tools");
        jMenu2.setMnemonic(84);
        ((JMenuBar)serializable).add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SequenceList.this.table.getSelectedRow();
                String string = (String)SequenceList.this.table.getValueAt(n, SequenceList.this.table.convertColumnIndexToView(0));
                SequenceList.this.seqModel;
                SequenceData sequenceData = (SequenceData)SequenceListTableModel.modelVector.elementAt(n);
                if (!sequenceData.s_remote.booleanValue()) {
                    DragTree.showFilePane(string, jembossParams);
                } else {
                    RemoteDragTree.showFilePane(string, jembossParams);
                }
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Calculate Sequence Attributes");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SequenceList.this.table.getSelectedRow();
                String string = SequenceList.this.table.getFileName(n);
                if (!string.equals("") && string != null) {
                    Object object;
                    SequenceList.this.setCursor(SequenceList.this.cbusy);
                    if (SequenceList.this.table.isListFile(n).booleanValue()) {
                        string = "list::" + string;
                    }
                    String string2 = AjaxUtil.getFileOrDatabaseForAjax(string, BuildProgramMenu.getDatabaseList(), null, bl);
                    boolean bl4 = false;
                    int n2 = 0;
                    if (!bl && string2 != null) {
                        2 v0 = this;
                        if (v0.jembossParams.isCygwin()) {
                            n2 = SequenceList.this.cygwinSeqAttr(string2, jembossParams);
                            if (n2 > -1) {
                                bl4 = true;
                            }
                        } else {
                            object = new Ajax();
                            bl4 = object.seqType(string2);
                            if (bl4) {
                                n2 = Ajax.length;
                                float f = Ajax.weight;
                                boolean bl2 = Ajax.protein;
                            }
                        }
                    } else if (string2 != null) {
                        try {
                            object = new CallAjax(string2, "sequence", jembossParams);
                            if (((CallAjax)object).getStatus().equals("0")) {
                                n2 = ((CallAjax)object).getLength();
                                float f = ((CallAjax)object).getWeight();
                                boolean bl3 = ((CallAjax)object).isProtein();
                                bl4 = true;
                            }
                        }
                        catch (JembossSoapException jembossSoapException) {
                            System.out.println("Call to Ajax library failed");
                            SequenceList.this.setCursor(SequenceList.this.cdone);
                        }
                    }
                    if (!bl4 && string2 != null) {
                        if (jembossParams.getServicePasswdByte() != null || !jembossParams.getUseAuth()) {
                            JOptionPane.showMessageDialog(null, "Sequence not found!", "Error Message", 0);
                        } else {
                            object = new AuthPopup(jembossParams, null);
                            ((AuthPopup)object).setBottomPanel();
                            ((Window)object).setSize(380, 170);
                            ((Window)object).pack();
                            ((Window)object).setVisible(true);
                        }
                    } else {
                        SequenceList.this.seqModel.setValueAt(new Integer(1), n, 1);
                        SequenceList.this.seqModel.setValueAt(new Integer(n2), n, 2);
                        SequenceList.this.table.repaint();
                    }
                    SequenceList.this.setCursor(SequenceList.this.cdone);
                }
            }
        });
        jMenu2.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Add Sequence");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SequenceList.this.table.getSelectedRow();
                SequenceList.this.seqModel.insertRow(n + 1);
                SequenceList.this.table.tableChanged(new TableModelEvent(SequenceList.this.seqModel, n + 1, n + 1, -1, 1));
            }
        });
        jMenu2.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Delete Sequence");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SequenceList.this.table.getSelectedRow();
                if (SequenceList.this.seqModel.deleteRow(n)) {
                    SequenceList.this.table.tableChanged(new TableModelEvent(SequenceList.this.seqModel, n, n, -1, -1));
                }
            }
        });
        jMenu2.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Remove All Sequences");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SequenceList.this.seqModel.setDefaultData();
                SequenceList.this.table.repaint();
            }
        });
        jMenu2.add(jMenuItem5);
        jMenu2.addSeparator();
        this.storeSeqList = new JCheckBoxMenuItem("Save Sequence List");
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jembossSeqList");
        if (file.canRead()) {
            this.storeSeqList.setSelected(true);
        } else {
            this.storeSeqList.setSelected(false);
        }
        jMenu2.add(this.storeSeqList);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem("Close");
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SequenceList.this.setVisible(false);
            }
        });
        jMenu.add(jMenuItem6);
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.setMnemonic(72);
        JMenuItem jMenuItem7 = new JMenuItem("About Sequence List");
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                try {
                    URL uRL = classLoader.getResource("resources/seqList.html");
                    new Browser(uRL, "resources/seqList.html");
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println("Didn't find resources/seqList.html");
                }
                catch (IOException iOException) {
                    System.out.println("Didn't find resources/seqList.html");
                }
            }
        });
        jMenu3.add(jMenuItem7);
        ((JMenuBar)serializable).add(jMenu3);
    }

    private int getDefaultRow() {
        int n = this.seqModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            Boolean bl = (Boolean)this.seqModel.getValueAt(i, 4);
            if (!bl.booleanValue()) continue;
            return i;
        }
        return -1;
    }

    private int cygwinSeqAttr(String string, JembossParams jembossParams) {
        String[] stringArray = new String[2];
        String string2 = new String(System.getProperty("path.separator"));
        String string3 = jembossParams.getEmbossPath();
        string3 = new String("PATH" + string2 + string3 + string2 + jembossParams.getEmbossBin() + string2);
        stringArray[0] = "PATH=" + string3;
        stringArray[1] = "EMBOSS_DATA=" + jembossParams.getEmbossData();
        String string4 = jembossParams.getEmbossBin().concat("infoseq -only -type -length -nohead -auto " + string);
        RunEmbossApplication2 runEmbossApplication2 = new RunEmbossApplication2(string4, stringArray, null);
        runEmbossApplication2.waitFor();
        String string5 = runEmbossApplication2.getProcessStdout();
        if (string5.trim().equals("")) {
            return -1;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5, "\n ");
        stringTokenizer.nextToken();
        return Integer.parseInt(stringTokenizer.nextToken().trim());
    }

    public String getDefaultSequenceName() {
        int n = this.getDefaultRow();
        if (n < 0) {
            return null;
        }
        String string = (String)this.seqModel.getValueAt(n, 0);
        if (this.table.isListFile(n).booleanValue()) {
            string = "@".concat(string);
        }
        return string;
    }

    public int getRowCount() {
        return this.seqModel.getRowCount();
    }

    public SequenceData getSequenceData(int n) {
        return this.seqModel.getSequenceData(n);
    }

    public boolean isStoreSequenceList() {
        return this.storeSeqList.isSelected();
    }
}

