/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.InputStreamSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class StreamStartCache
implements InputStreamSource {
    private static final Logger logger = Logger.getLogger(StreamStartCache.class);
    public static final int CACHE_SIZE = 10240;
    private byte[] cache;
    private InputStreamSource source;

    public StreamStartCache(InputStream initialiser, InputStreamSource source) throws IOException {
        byte[] tempCache = new byte[10240];
        int read = initialiser.read(tempCache);
        if (read == -1) {
            read = 0;
        }
        this.cache = new byte[read];
        System.arraycopy(tempCache, 0, this.cache, 0, read);
        this.source = source;
    }

    private ByteArrayInputStream getByteArrayInputStream() {
        return new ByteArrayInputStream(this.cache);
    }

    @Override
    public InputStream getInputStream() {
        return new StartCachedInputStream(this.getByteArrayInputStream(), this.source);
    }

    private static class StartCachedInputStream
    extends InputStream {
        private ByteArrayInputStream cachedStream;
        private InputStream stream = null;
        private InputStreamSource source;
        private boolean useCache = true;
        private int cachePosition = 0;

        StartCachedInputStream(ByteArrayInputStream cachedStream, InputStreamSource source) {
            this.cachedStream = cachedStream;
            this.source = source;
        }

        @Override
        public int read() throws IOException {
            if (this.useCache && this.cachedStream.available() == 0) {
                logger.debug((Object)"stream start cache miss");
                this.useCache = false;
                this.stream = this.source.getInputStream();
                for (int i = 0; i < this.cachePosition; ++i) {
                    this.stream.read();
                }
            }
            if (this.useCache) {
                ++this.cachePosition;
                return this.cachedStream.read();
            }
            return this.stream.read();
        }
    }
}

