/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.util.XmlUtil;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ModuleDescriptionMessage
extends ChipsterMessage {
    private static final String KEY_MODULE = "module";
    private static final String KEY_MODULE_NAME = "module-name";
    public Document moduleXml;
    private String moduleName;
    private List<Category> categories = new LinkedList<Category>();

    public ModuleDescriptionMessage() {
    }

    public ModuleDescriptionMessage(String moduleName) {
        try {
            this.moduleXml = XmlUtil.newDocument();
            this.moduleXml.appendChild(this.moduleXml.createElement(KEY_MODULE));
            this.setModuleName(moduleName);
            this.getFirstModule().setAttribute("name", moduleName);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void addConfString(String configuration) {
    }

    private Element getFirstModule() {
        return (Element)this.moduleXml.getElementsByTagName(KEY_MODULE).item(0);
    }

    public void addCategory(Category category) {
        Element categoryElement = this.moduleXml.createElement("category");
        categoryElement.setAttribute("name", category.getName());
        String colorString = Integer.toHexString(category.getColor().getRGB());
        colorString = "#" + colorString.substring(2, colorString.length());
        categoryElement.setAttribute("color", colorString);
        categoryElement.setAttribute("hidden", category.isHidden().toString());
        for (Tool tool : category.getTools()) {
            Element toolElement = this.moduleXml.createElement("tool");
            toolElement.setAttribute("helpURL", tool.getHelpURL());
            toolElement.setTextContent(tool.getDescription());
            categoryElement.appendChild(toolElement);
        }
        this.getFirstModule().appendChild(categoryElement);
    }

    public List<Category> getCategories() {
        NodeList categoryList = this.getFirstModule().getElementsByTagName("category");
        for (int i = 0; i < categoryList.getLength(); ++i) {
            Element categoryElement = (Element)categoryList.item(i);
            Category category = new Category(categoryElement.getAttribute("name"), categoryElement.getAttribute("color"), Boolean.valueOf(categoryElement.getAttribute("hidden")));
            NodeList toolList = categoryElement.getElementsByTagName("tool");
            for (int j = 0; j < toolList.getLength(); ++j) {
                Element toolElement = (Element)toolList.item(j);
                category.addTool(toolElement.getTextContent(), toolElement.getAttribute("helpURL"));
            }
            this.categories.add(category);
        }
        return this.categories;
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        this.setModuleName(from.getStringProperty(KEY_MODULE_NAME));
        this.moduleXml = XmlUtil.stringToXML(from.getString(KEY_MODULE));
    }

    @Override
    public void marshal(MapMessage to) throws JMSException {
        super.marshal(to);
        to.setStringProperty(KEY_MODULE_NAME, this.getModuleName());
        to.setString(KEY_MODULE, XmlUtil.xmlToString(this.moduleXml));
    }

    public static class Tool {
        private String description;
        private String helpURL;

        public Tool(String description, String helpURL) {
            this.description = description;
            this.helpURL = helpURL;
        }

        public String getHelpURL() {
            return this.helpURL;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class Category {
        private String name;
        private List<Tool> tools = new LinkedList<Tool>();
        private Color color;
        private Boolean hidden;

        public Category(String name, String color, Boolean hidden) {
            this.name = name;
            this.color = Color.decode(color);
            this.hidden = hidden;
        }

        public String getName() {
            return this.name;
        }

        public Color getColor() {
            return this.color;
        }

        public Boolean isHidden() {
            return this.hidden;
        }

        public void addTool(String description, String helpURL) {
            this.tools.add(new Tool(description, helpURL));
        }

        public List<Tool> getTools() {
            return this.tools;
        }
    }
}

