/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ReferenceSNPTrack
extends Track {
    private static int width = 8;
    Collection<RegionContent> values = new LinkedList<RegionContent>();
    Long lastPosition;
    long maxBpLength;
    long minBpLength;
    Color a = new Color(64, 192, 64, 128);
    Color c = new Color(64, 64, 192, 128);
    Color g = new Color(128, 128, 128, 128);
    Color t = new Color(192, 64, 64, 128);
    Color forExceptions = new Color(139, 69, 19, 128);
    private Color[] colors = new Color[]{new Color(255, 0, 0, 128), new Color(255, 0, 0, 128), new Color(255, 105, 180, 128), new Color(255, 215, 0, 128), new Color(50, 205, 50, 128), new Color(0, 0, 255, 128), new Color(190, 190, 190, 128)};
    private int maxColorIndex = this.colors.length - 1;
    private int lastConsequenceNumber = -1;
    boolean changeView = true;

    public ReferenceSNPTrack(View view, DataSource file, long minBpLength, long maxBpLength) {
        super(view, file);
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Iterator<RegionContent> iter = this.values.iterator();
        if (this.values != null) {
            while (iter.hasNext()) {
                RegionContent value = iter.next();
                if (!value.region.intersects(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                if (this.lastPosition == null) {
                    this.lastPosition = (long)this.getView().bpToTrack(value.region.start);
                }
                if (this.lastConsequenceNumber == -1) {
                    this.lastConsequenceNumber = ConsequenceName.valueOf((String)value.values.get((Object)ColumnType.CONSEQUENCE_TO_TRANSCRIPT)).ordinal();
                }
                String allele = (String)value.values.get((Object)ColumnType.ALLELE);
                long position = this.getView().bpToTrack(value.region.start).intValue();
                if (this.changeView) {
                    int now;
                    String consequence = (String)value.values.get((Object)ColumnType.CONSEQUENCE_TO_TRANSCRIPT);
                    try {
                        now = ConsequenceName.valueOf(consequence).ordinal();
                    }
                    catch (Exception e) {
                        now = ConsequenceName.NONE.ordinal();
                    }
                    if (this.lastPosition != position) {
                        drawables.add(new RectDrawable((int)position, 1, width, this.getHeight(), this.colors[now > this.maxColorIndex ? this.maxColorIndex : now], this.colors[now > this.maxColorIndex ? this.maxColorIndex : now]));
                    }
                    if (this.lastConsequenceNumber < now) {
                        drawables.add(new RectDrawable((int)position, 1, width, this.getHeight(), this.colors[now > this.maxColorIndex ? this.maxColorIndex : now], this.colors[now > this.maxColorIndex ? this.maxColorIndex : now]));
                    } else {
                        drawables.add(new RectDrawable((int)position, 1, width, this.getHeight(), this.colors[this.lastConsequenceNumber > this.maxColorIndex ? this.maxColorIndex : this.lastConsequenceNumber], this.colors[this.lastConsequenceNumber > this.maxColorIndex ? this.maxColorIndex : this.lastConsequenceNumber]));
                    }
                } else if (allele.matches("[ACGT]/A")) {
                    drawables.add(new RectDrawable((int)position, 1, width, this.getHeight(), this.a, this.a));
                } else if (allele.matches("[ACGT]/C")) {
                    drawables.add(new RectDrawable((int)position, 1, width, this.getHeight(), this.c, this.c));
                } else if (allele.matches("[ACGT]/G")) {
                    drawables.add(new RectDrawable((int)position, 1, width, this.getHeight(), this.g, this.g));
                } else if (allele.matches("[ACGT]/T")) {
                    drawables.add(new RectDrawable((int)position, 1, width, this.getHeight(), this.t, this.t));
                } else {
                    drawables.add(new RectDrawable((int)position, 1, width, this.getHeight(), this.forExceptions, this.forExceptions));
                }
                this.lastPosition = position;
                this.lastConsequenceNumber = ConsequenceName.valueOf((String)value.values.get((Object)ColumnType.CONSEQUENCE_TO_TRANSCRIPT)).ordinal();
            }
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent content : areaResult.getContents()) {
            if (content.values.get((Object)ColumnType.STRAND) != this.getStrand()) continue;
            this.values.add(content);
        }
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.POSITION, ColumnType.STRAND, ColumnType.CONSEQUENCE_TO_TRANSCRIPT, ColumnType.ALLELE)));
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    @Override
    public boolean isStretchable() {
        return this.isVisible();
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return 12;
        }
        return 0;
    }

    public void changeSNPView() {
        this.changeView = true;
        this.view.getQueueManager().addResultListener(this.file, this);
    }

    public void returnSNPView() {
        this.changeView = false;
    }

    @Override
    public String getName() {
        return "SNPTrack";
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    static enum ConsequenceName {
        STOP_GAINED,
        STOP_LOST,
        FRAMESHIFT_CODING,
        SYNONYMOUS_CODING,
        NON_SYNONYMOUS_CODING,
        WITHIN_MATURE_miRNA,
        UPSTREAM,
        DOWNSTREAM,
        INTRONIC,
        INTERGENETIC,
        COMPLEX_INDEL,
        PARTIAL_CODON,
        REGULATORY_REGION,
        WITHIN_MATURE_mIRNA,
        PRIME5_UTR,
        PRIME3_UTR,
        STOP_GAINED_FRAMESHIFT,
        STOP_GAINED_SPLICE_SITE,
        STOP_LOST_SPLICE_SITE,
        FRAMESHIFT_CODING_SPLICE_SITE,
        STOP_GAINED_FRAMESHIFT_CODING_SPLICE_SITE,
        NON_SYNONYMOUS_CODING_SPLICE_SITE,
        SPLICE_SITE_SYNONYMOUS_CODING,
        SPLICE_SITE_5PRIME_UTR,
        SPLICE_SITE_3PRIME_UTR,
        ESSENTIAL_SPLICE_SITE_INTRONIC,
        SPLICE_SITE_INTRONIC,
        WITHIN_NON_CODING_GENE,
        INTRONIC_NMD_TRANSCRIPT,
        NONE;

    }
}

