/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.bsh;

import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.LookaheadLineReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public class JavaJobUtils {
    public static String[] getGeneNames(File file) throws IOException {
        return JavaJobUtils.getColumns(file, new String[]{"symbol", " ", "identifier"});
    }

    public static String[] getProbes(File file) throws IOException {
        return JavaJobUtils.getColumns(file, new String[]{" "});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getColumns(File file, String[] lookForColumns) throws IOException {
        LinkedList<String> names = new LinkedList<String>();
        LookaheadLineReader reader = new LookaheadLineReader(new BufferedReader(new FileReader(file)));
        try {
            String line = reader.readLine();
            if (line == null) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] columns = line.split("\t");
            if (reader.peekLine().split("\t").length == columns.length + 1) {
                String[] newColumns = new String[columns.length + 1];
                System.arraycopy(columns, 0, newColumns, 1, columns.length);
                newColumns[0] = " ";
                columns = newColumns;
            }
            int nameColumnIndex = -1;
            for (String lookForColumn : lookForColumns) {
                nameColumnIndex = Arrays.asList(columns).indexOf(lookForColumn);
                if (nameColumnIndex != -1) break;
            }
            if (nameColumnIndex == -1) {
                throw new IOException("data does not contain any of the required columns: " + Arrays.asList(lookForColumns));
            }
            line = reader.readLine();
            while (line != null) {
                names.add(line.split("\t")[nameColumnIndex]);
                line = reader.readLine();
            }
        }
        finally {
            IOUtils.closeIfPossible(reader.getReader());
        }
        return names.toArray(new String[names.size()]);
    }
}

