/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.views.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;

public class SelectionBoxHandler {
    protected static float[] dash1 = new float[]{1.0f};
    protected static BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 1.0f, dash1, 0.0f);
    protected Rectangle currentRect = null;
    protected Rectangle rectToDraw = null;
    protected Rectangle previousRectDrawn = new Rectangle();
    protected Color selectionBoxColour = Color.lightGray;

    public void paintSelectionBox(Graphics g) {
        Graphics2D gg = (Graphics2D)g;
        Color oldColor = gg.getColor();
        Stroke oldStroke = gg.getStroke();
        if (this.rectToDraw != null) {
            oldColor = g.getColor();
            g.setColor(this.selectionBoxColour);
            gg.setStroke(stroke);
            g.drawRect(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width - 1, this.rectToDraw.height - 1);
            g.setColor(oldColor);
        }
        gg.setColor(oldColor);
        gg.setStroke(oldStroke);
    }

    public void resetRectangle(int x, int y) {
        this.currentRect = new Rectangle(x, y, 0, 0);
    }

    public Rectangle getCurrentRect() {
        return this.currentRect;
    }

    public void setCurrentRect(Rectangle currentRect) {
        this.currentRect = currentRect;
    }

    public Rectangle getRectToDraw() {
        return this.rectToDraw;
    }

    public void setRectToDraw(Rectangle rectToDraw) {
        this.rectToDraw = rectToDraw;
    }

    public void clearRectangle(Component component) {
        this.currentRect = new Rectangle(0, 0, 0, 0);
        this.updateDrawableRect(component.getWidth(), component.getHeight());
    }

    public void updateSelectionSize(MouseEvent e, Component component) {
        int x = e.getX();
        int y = e.getY();
        if (this.currentRect == null) {
            this.currentRect = new Rectangle(x, y, 0, 0);
        }
        this.currentRect.setSize(x - this.currentRect.x, y - this.currentRect.y);
        this.updateDrawableRect(component.getWidth(), component.getHeight());
        Rectangle totalRepaint = this.rectToDraw.union(this.previousRectDrawn);
        component.repaint(totalRepaint.x, totalRepaint.y, totalRepaint.width, totalRepaint.height);
    }

    public void setSelectionSize(Rectangle rect, Component component) {
        this.currentRect = rect;
        this.updateDrawableRect(component.getWidth(), component.getHeight());
        Rectangle totalRepaint = this.rectToDraw.union(this.previousRectDrawn);
        component.repaint(totalRepaint.x, totalRepaint.y, totalRepaint.width, totalRepaint.height);
    }

    public void updateDrawableRect(int compWidth, int compHeight) {
        int x = this.currentRect.x;
        int y = this.currentRect.y;
        int width = this.currentRect.width;
        int height = this.currentRect.height;
        if (width < 0 && (x = x - (width = 0 - width) + 1) < 0) {
            width += x;
            x = 0;
        }
        if (height < 0 && (y = y - (height = 0 - height) + 1) < 0) {
            height += y;
            y = 0;
        }
        if (x + width > compWidth) {
            width = compWidth - x;
        }
        if (y + height > compHeight) {
            height = compHeight - y;
        }
        if (this.rectToDraw != null) {
            this.previousRectDrawn.setBounds(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
            this.rectToDraw.setBounds(x, y, width, height);
        } else {
            this.rectToDraw = new Rectangle(x, y, width, height);
        }
    }
}

