/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Holder
extends AbstractLifeCycle {
    protected final Map<String, String> _initParams = new HashMap<String, String>(3);
    protected transient Class<?> _class;
    protected String _className;
    protected String _displayName;
    protected boolean _extInstance;
    protected boolean _asyncSupported = true;
    protected String _name;
    protected ServletHandler _servletHandler;

    protected Holder() {
    }

    protected Holder(Class held) {
        this._class = held;
        if (held != null) {
            this._className = held.getName();
            this._name = held.getName() + "-" + this.hashCode();
        }
    }

    @Override
    public void doStart() throws Exception {
        if (this._class == null && (this._className == null || this._className.equals(""))) {
            throw new UnavailableException("No class for Servlet or Filter", -1);
        }
        if (this._class == null) {
            try {
                this._class = Loader.loadClass(Holder.class, this._className);
                if (Log.isDebugEnabled()) {
                    Log.debug("Holding {}", this._class);
                }
            }
            catch (Exception e) {
                Log.warn(e);
                throw new UnavailableException(e.getMessage(), -1);
            }
        }
    }

    @Override
    public void doStop() throws Exception {
        if (!this._extInstance) {
            this._class = null;
        }
    }

    public String getClassName() {
        return this._className;
    }

    public Class getHeldClass() {
        return this._class;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getInitParameter(String param) {
        if (this._initParams == null) {
            return null;
        }
        return this._initParams.get(param);
    }

    public Enumeration getInitParameterNames() {
        if (this._initParams == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._initParams.keySet());
    }

    public Map getInitParameters() {
        return this._initParams;
    }

    public String getName() {
        return this._name;
    }

    public ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    public synchronized Object newInstance() throws InstantiationException, IllegalAccessException {
        if (this._class == null) {
            throw new InstantiationException("!" + this._className);
        }
        return this._class.newInstance();
    }

    public void destroyInstance(Object instance) throws Exception {
    }

    public void setClassName(String className) {
        this._className = className;
        this._class = null;
    }

    public void setHeldClass(Class held) {
        this._class = held;
        this._className = held != null ? held.getName() : null;
    }

    public void setDisplayName(String name) {
        this._displayName = name;
    }

    public void setInitParameter(String param, String value) {
        this._initParams.put(param, value);
    }

    public void setInitParameters(Map<String, String> map) {
        this._initParams.clear();
        this._initParams.putAll(map);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this._servletHandler = servletHandler;
    }

    public void setAsyncSupported(boolean suspendable) {
        this._asyncSupported = suspendable;
    }

    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    public String toString() {
        return this._name;
    }

    protected void illegalStateIfContextStarted() {
        ContextHandler.Context context;
        if (this._servletHandler != null && (context = (ContextHandler.Context)this._servletHandler.getServletContext()) != null && context.getContextHandler().isStarted()) {
            throw new IllegalStateException("Started");
        }
    }

    protected class HolderConfig {
        protected HolderConfig() {
        }

        public ServletContext getServletContext() {
            return Holder.this._servletHandler.getServletContext();
        }

        public String getInitParameter(String param) {
            return Holder.this.getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return Holder.this.getInitParameterNames();
        }
    }
}

