/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.IObjectFactory;
import org.testng.TestNGException;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestNGContentHandler
extends DefaultHandler {
    private XmlSuite m_currentSuite = null;
    private XmlTest m_currentTest = null;
    private List<String> m_currentDefines = null;
    private List<String> m_currentRuns = null;
    private List<String> m_currentGroups = null;
    private List<XmlClass> m_currentClasses = null;
    private List<XmlPackage> m_currentPackages = null;
    private XmlPackage m_currentPackage = null;
    private List<XmlSuite> m_suites = new ArrayList<XmlSuite>();
    private List<String> m_currentIncludedGroups = null;
    private List<String> m_currentExcludedGroups = null;
    private Map<String, String> m_currentTestParameters = null;
    private Map<String, String> m_currentSuiteParameters = null;
    private ArrayList<String> m_currentMetaGroup = null;
    private String m_currentMetaGroupName;
    private boolean m_inTest = false;
    private XmlClass m_currentClass = null;
    private ArrayList<String> m_currentIncludedMethods = null;
    private ArrayList<String> m_currentExcludedMethods = null;
    private ArrayList<XmlMethodSelector> m_currentSelectors = null;
    private XmlMethodSelector m_currentSelector = null;
    private String m_currentLanguage = null;
    private String m_currentExpression = null;
    private List<String> m_suiteFiles = new ArrayList<String>();
    private boolean m_enabledTest;
    private List<String> m_listeners;
    private String m_fileName;

    public TestNGContentHandler(String fileName) {
        this.m_fileName = fileName;
    }

    private static void ppp(String s) {
        System.out.println("[TestNGContentHandler] " + s);
    }

    public InputSource resolveEntity(String systemId, String publicId) throws IOException, SAXException {
        InputSource result = null;
        if ("http://beust.com/testng/testng-1.0.dtd".equals(publicId) || "http://testng.org/testng-1.0.dtd".equals(publicId)) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("testng-1.0.dtd");
            if (null == is) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("testng-1.0.dtd");
                if (null == is) {
                    System.out.println("WARNING: couldn't find in classpath " + publicId + "\n" + "Fetching it from the Web site.");
                    result = super.resolveEntity(systemId, publicId);
                } else {
                    result = new InputSource(is);
                }
            } else {
                result = new InputSource(is);
            }
        } else {
            result = super.resolveEntity(systemId, publicId);
        }
        return result;
    }

    private void xmlSuiteFile(boolean start, Attributes attributes) {
        if (start) {
            String path = attributes.getValue("path");
            this.m_suiteFiles.add(path);
        } else {
            this.m_currentSuite.setSuiteFiles(this.m_suiteFiles);
        }
    }

    private void xmlSuite(boolean start, Attributes attributes) {
        if (start) {
            String objectFactory;
            String timeOut;
            String annotations;
            String threadCount;
            String skip;
            String parallel;
            String name = attributes.getValue("name");
            this.m_currentSuite = new XmlSuite();
            this.m_currentSuite.setFileName(this.m_fileName);
            this.m_currentSuite.setName(name);
            this.m_currentSuiteParameters = new HashMap<String, String>();
            String verbose = attributes.getValue("verbose");
            if (null != verbose) {
                this.m_currentSuite.setVerbose(new Integer(verbose));
            }
            if (null != (parallel = attributes.getValue("parallel"))) {
                if ("methods".equals(parallel) || "tests".equals(parallel) || "none".equals(parallel) || "classes".equals(parallel) || "true".equals(parallel) || "false".equals(parallel)) {
                    this.m_currentSuite.setParallel(parallel);
                } else {
                    Utils.log("Parser", 1, "[WARN] Unknown value of attribute 'parallel' at suite level: '" + parallel + "'.");
                }
            }
            if ((skip = attributes.getValue("skipfailedinvocationcounts")) != null) {
                this.m_currentSuite.setSkipFailedInvocationCounts(Boolean.valueOf(skip));
            }
            if (null != (threadCount = attributes.getValue("thread-count"))) {
                this.m_currentSuite.setThreadCount(Integer.parseInt(threadCount));
            }
            if (null != (annotations = attributes.getValue("annotations"))) {
                this.m_currentSuite.setAnnotations(annotations);
            }
            if (null != (timeOut = attributes.getValue("time-out"))) {
                this.m_currentSuite.setTimeOut(timeOut);
            }
            if (null != (objectFactory = attributes.getValue("object-factory"))) {
                try {
                    this.m_currentSuite.setObjectFactory((IObjectFactory)Class.forName(objectFactory).newInstance());
                }
                catch (Exception e) {
                    Utils.log("Parser", 1, "[ERROR] Unable to create custom object factory '" + objectFactory + "' :" + e);
                }
            }
        } else {
            this.m_currentSuite.setParameters(this.m_currentSuiteParameters);
            this.m_suites.add(this.m_currentSuite);
            this.m_currentSuiteParameters = null;
        }
    }

    private void xmlDefine(boolean start, Attributes attributes) {
        if (start) {
            String name = attributes.getValue("name");
            this.m_currentDefines = new ArrayList<String>();
            this.m_currentMetaGroup = new ArrayList();
            this.m_currentMetaGroupName = name;
        } else {
            this.m_currentTest.addMetaGroup(this.m_currentMetaGroupName, this.m_currentMetaGroup);
            this.m_currentDefines = null;
        }
    }

    private void xmlScript(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentLanguage = attributes.getValue("language");
            this.m_currentExpression = "";
        } else {
            this.m_currentSelector.setExpression(this.m_currentExpression);
            this.m_currentSelector.setLanguage(this.m_currentLanguage);
            if (this.m_inTest) {
                this.m_currentTest.setBeanShellExpression(this.m_currentExpression);
            } else {
                this.m_currentSuite.setBeanShellExpression(this.m_currentExpression);
            }
            this.m_currentLanguage = null;
            this.m_currentExpression = null;
        }
    }

    private void xmlTest(boolean start, Attributes attributes) {
        if (start) {
            String annotations;
            String timeOut;
            String threadCount;
            String parallel;
            String skip;
            String jUnit;
            this.m_currentTest = new XmlTest(this.m_currentSuite);
            this.m_currentTestParameters = new HashMap<String, String>();
            String testName = attributes.getValue("name");
            if (null == testName || "".equals(testName.trim())) {
                throw new TestNGException("Test <test> element must define the name attribute");
            }
            this.m_currentTest.setName(attributes.getValue("name"));
            String verbose = attributes.getValue("verbose");
            if (null != verbose) {
                this.m_currentTest.setVerbose(Integer.parseInt(verbose));
            }
            if (null != (jUnit = attributes.getValue("junit"))) {
                this.m_currentTest.setJUnit(Boolean.valueOf(jUnit));
            }
            if ((skip = attributes.getValue("skipfailedinvocationcounts")) != null) {
                this.m_currentTest.setSkipFailedInvocationCounts(Boolean.valueOf(skip));
            }
            if (null != (parallel = attributes.getValue("parallel"))) {
                if ("methods".equals(parallel) || "none".equals(parallel) || "true".equals(parallel) || "false".equals(parallel)) {
                    this.m_currentTest.setParallel(parallel);
                } else {
                    Utils.log("Parser", 1, "[WARN] Unknown value of attribute 'parallel' for test '" + this.m_currentTest.getName() + "': '" + parallel + "'");
                }
            }
            if (null != (threadCount = attributes.getValue("thread-count"))) {
                this.m_currentTest.setThreadCount(Integer.parseInt(threadCount));
            }
            if (null != (timeOut = attributes.getValue("time-out"))) {
                this.m_currentTest.setTimeOut(Long.parseLong(timeOut));
            }
            if (null != (annotations = attributes.getValue("annotations"))) {
                this.m_currentTest.setAnnotations(annotations);
            }
            this.m_inTest = true;
            this.m_enabledTest = true;
            String enabledTestString = attributes.getValue("enabled");
            if (null != enabledTestString) {
                this.m_enabledTest = Boolean.valueOf(enabledTestString);
            }
        } else {
            if (null != this.m_currentTestParameters && this.m_currentTestParameters.size() > 0) {
                this.m_currentTest.setParameters(this.m_currentTestParameters);
            }
            if (null != this.m_currentClasses) {
                this.m_currentTest.setXmlClasses(this.m_currentClasses);
            }
            this.m_currentClasses = null;
            this.m_currentTest = null;
            this.m_currentTestParameters = null;
            this.m_inTest = false;
            if (!this.m_enabledTest) {
                List<XmlTest> tests = this.m_currentSuite.getTests();
                tests.remove(tests.size() - 1);
            }
        }
    }

    public void xmlClasses(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentClasses = new ArrayList<XmlClass>();
        } else {
            this.m_currentTest.setXmlClasses(this.m_currentClasses);
            this.m_currentClasses = null;
        }
    }

    public void xmlListeners(boolean start, Attributes attributes) {
        if (start) {
            this.m_listeners = new ArrayList<String>();
        } else if (null != this.m_listeners) {
            this.m_currentSuite.setListeners(this.m_listeners);
            this.m_listeners = null;
        }
    }

    public void xmlListener(boolean start, Attributes attributes) {
        if (start) {
            String listener = attributes.getValue("class-name");
            this.m_listeners.add(listener);
        }
    }

    public void xmlPackages(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentPackages = new ArrayList<XmlPackage>();
        } else {
            if (null != this.m_currentPackages) {
                if (this.m_inTest) {
                    this.m_currentTest.setXmlPackages(this.m_currentPackages);
                } else {
                    this.m_currentSuite.setXmlPackages(this.m_currentPackages);
                }
            }
            this.m_currentPackages = null;
            this.m_currentPackage = null;
        }
    }

    public void xmlMethodSelectors(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentSelectors = new ArrayList();
        } else {
            if (this.m_inTest) {
                this.m_currentTest.setMethodSelectors(this.m_currentSelectors);
            } else {
                this.m_currentSuite.setMethodSelectors(this.m_currentSelectors);
            }
            this.m_currentSelectors = null;
        }
    }

    public void xmlSelectorClass(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentSelector.setName(attributes.getValue("name"));
            String priority = attributes.getValue("priority");
            if (priority == null) {
                priority = "0";
            }
            this.m_currentSelector.setPriority(new Integer(priority));
        }
    }

    public void xmlMethodSelector(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentSelector = new XmlMethodSelector();
        } else {
            this.m_currentSelectors.add(this.m_currentSelector);
            this.m_currentSelector = null;
        }
    }

    private void xmlMethod(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentIncludedMethods = new ArrayList();
            this.m_currentExcludedMethods = new ArrayList();
        } else {
            this.m_currentClass.setIncludedMethods(this.m_currentIncludedMethods);
            this.m_currentClass.setExcludedMethods(this.m_currentExcludedMethods);
            this.m_currentIncludedMethods = null;
            this.m_currentExcludedMethods = null;
        }
    }

    public void xmlRun(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentRuns = new ArrayList<String>();
        } else {
            this.m_currentTest.setIncludedGroups(this.m_currentIncludedGroups);
            this.m_currentTest.setExcludedGroups(this.m_currentExcludedGroups);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        if ("suite".equals(qName)) {
            this.xmlSuite(true, attributes);
        } else if ("suite-file".equals(qName)) {
            this.xmlSuiteFile(true, attributes);
        } else if ("test".equals(qName)) {
            this.xmlTest(true, attributes);
        } else if ("script".equals(qName)) {
            this.xmlScript(true, attributes);
        } else if ("method-selector".equals(qName)) {
            this.xmlMethodSelector(true, attributes);
        } else if ("method-selectors".equals(qName)) {
            this.xmlMethodSelectors(true, attributes);
        } else if ("selector-class".equals(qName)) {
            this.xmlSelectorClass(true, attributes);
        } else if ("classes".equals(qName)) {
            this.xmlClasses(true, attributes);
        } else if ("packages".equals(qName)) {
            this.xmlPackages(true, attributes);
        } else if ("listeners".equals(qName)) {
            this.xmlListeners(true, attributes);
        } else if ("listener".equals(qName)) {
            this.xmlListener(true, attributes);
        } else if ("class".equals(qName)) {
            if (null != this.m_currentClasses) {
                this.m_currentClass = new XmlClass(name, Boolean.TRUE);
                this.m_currentClasses.add(this.m_currentClass);
            }
        } else if ("package".equals(qName)) {
            if (null != this.m_currentPackages) {
                this.m_currentPackage = new XmlPackage();
                this.m_currentPackage.setName(name);
                this.m_currentPackages.add(this.m_currentPackage);
            }
        } else if ("define".equals(qName)) {
            this.xmlDefine(true, attributes);
        } else if ("run".equals(qName)) {
            this.xmlRun(true, attributes);
        } else if ("groups".equals(qName)) {
            this.m_currentIncludedGroups = new ArrayList<String>();
            this.m_currentExcludedGroups = new ArrayList<String>();
        } else if ("methods".equals(qName)) {
            this.xmlMethod(true, attributes);
        } else if ("include".equals(qName)) {
            if (null != this.m_currentIncludedMethods) {
                this.m_currentIncludedMethods.add(name);
            } else if (null != this.m_currentDefines) {
                this.m_currentMetaGroup.add(name);
            } else if (null != this.m_currentRuns) {
                this.m_currentIncludedGroups.add(name);
            } else if (null != this.m_currentPackage) {
                this.m_currentPackage.getInclude().add(name);
            }
        } else if ("exclude".equals(qName)) {
            if (null != this.m_currentExcludedMethods) {
                this.m_currentExcludedMethods.add(name);
            } else if (null != this.m_currentRuns) {
                this.m_currentExcludedGroups.add(name);
            } else if (null != this.m_currentPackage) {
                this.m_currentPackage.getExclude().add(name);
            }
        } else if ("parameter".equals(qName)) {
            String value = attributes.getValue("value");
            if (this.m_inTest) {
                this.m_currentTestParameters.put(name, value);
            } else {
                this.m_currentSuiteParameters.put(name, value);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("suite".equals(qName)) {
            this.xmlSuite(false, null);
        } else if ("suite-file".equals(qName)) {
            this.xmlSuiteFile(false, null);
        } else if ("test".equals(qName)) {
            this.xmlTest(false, null);
        } else if ("define".equals(qName)) {
            this.xmlDefine(false, null);
        } else if ("run".equals(qName)) {
            this.xmlRun(false, null);
        } else if ("methods".equals(qName)) {
            this.xmlMethod(false, null);
        } else if ("classes".equals(qName)) {
            this.xmlClasses(false, null);
        } else if ("classes".equals(qName)) {
            this.xmlPackages(false, null);
        } else if ("listeners".equals(qName)) {
            this.xmlListeners(false, null);
        } else if ("method-selector".equals(qName)) {
            this.xmlMethodSelector(false, null);
        } else if ("method-selectors".equals(qName)) {
            this.xmlMethodSelectors(false, null);
        } else if ("selector-class".equals(qName)) {
            this.xmlSelectorClass(false, null);
        } else if ("script".equals(qName)) {
            this.xmlScript(false, null);
        } else if ("packages".equals(qName)) {
            this.xmlPackages(false, null);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    private boolean areWhiteSpaces(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            char c = ch[i];
            if (c == '\n' || c == '\t' || c == ' ') continue;
            return false;
        }
        return true;
    }

    public void characters(char[] ch, int start, int length) {
        if (null != this.m_currentLanguage && !this.areWhiteSpaces(ch, start, length)) {
            this.m_currentExpression = this.m_currentExpression + new String(ch, start, length);
        }
    }

    public XmlSuite getSuite() {
        return this.m_currentSuite;
    }
}

