/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.IOException;
import java.util.Iterator;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.TabixFeatureReader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.TribbleIndexedFeatureReader;
import org.broad.tribble.index.Index;
import org.broad.tribble.util.ParsingUtils;

public abstract class AbstractFeatureReader<T extends Feature>
implements FeatureReader<T> {
    String path;
    protected final FeatureCodec codec;
    protected FeatureCodecHeader header;

    public static final AbstractFeatureReader getFeatureReader(String featureFile, FeatureCodec codec) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(featureFile, codec, true);
    }

    public static final AbstractFeatureReader getFeatureReader(String featureResource, FeatureCodec codec, boolean requireIndex) throws TribbleException {
        try {
            if (featureResource.endsWith(".gz") && ParsingUtils.resourceExists(String.valueOf(featureResource) + ".tbi")) {
                if (!(codec instanceof AsciiFeatureCodec)) {
                    throw new TribbleException("Tabix indexed files only work with ASCII codecs, but received non-Ascii codec " + codec.getClass().getSimpleName());
                }
                return new TabixFeatureReader(featureResource, (AsciiFeatureCodec)codec);
            }
            return new TribbleIndexedFeatureReader(featureResource, codec, requireIndex);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to create BasicFeatureReader using feature file ", featureResource, e);
        }
        catch (TribbleException e) {
            e.setSource(featureResource);
            throw e;
        }
    }

    public static final AbstractFeatureReader getFeatureReader(String featureResource, FeatureCodec codec, Index index) throws TribbleException {
        try {
            return new TribbleIndexedFeatureReader(featureResource, codec, index);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to create AbstractFeatureReader using feature file ", featureResource, e);
        }
    }

    protected AbstractFeatureReader(String path, FeatureCodec codec) {
        this.path = path;
        this.codec = codec;
    }

    @Override
    public Object getHeader() {
        return this.header.getHeaderValue();
    }

    static class EmptyIterator<T extends Feature>
    implements CloseableTribbleIterator {
        EmptyIterator() {
        }

        @Override
        public Iterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
        }
    }
}

