package org.jfree.chart.plot.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.chart.plot.DummyHCClusteringInfo;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.data.hc.DataRange;

import java.util.List;
import java.util.LinkedList;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;




/**
 * Tests for the {@link org.jfree.chart.plot.DummyHCClusteringInfo} class.
 */

public class DummyHCClusteringInfoTests extends TestCase {

    private String[] names;
    private int location;

   /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(DummyHCClusteringInfoTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public DummyHCClusteringInfoTests(String name)
           throws Exception {

        super(name);

        this.names = new String[] {"names1","names2"};
        this.location = 1;
    }

    /**
     * Tests the constructor
     */
    public void testConstructor() {

        String s1 = "location must be LEFT or RIGHT.";
        String s2 = "Names of a DummyHCClusteringInfo cannot be null.";


        try {
            new DummyHCClusteringInfo(
                this.names, -1);
            assertTrue(false);
        } catch (IllegalArgumentException e) {
            assertTrue(s1.equals(e.getMessage()));
        }

        try {
            new DummyHCClusteringInfo(
                this.names, 2);
            assertTrue(false);
        } catch (IllegalArgumentException e) {
            assertTrue(s1.equals(e.getMessage()));
        }

        try {
            new DummyHCClusteringInfo(
                null, this.location);
            assertTrue(false);
        } catch (NullPointerException e) {
            assertTrue(s2.equals(e.getMessage()));
        }


        assertNotNull(new DummyHCClusteringInfo(
                this.names, this.location));

    }

    /**
     * Checks the methods.
     */
    public void testMethods() {
        DummyHCClusteringInfo dinfo =
            new DummyHCClusteringInfo(this.names, this.location);
        assertTrue(2 == dinfo.getNumberOfVisibleItems());
        assertNull(dinfo.getRootNode());
        System.out.println(dinfo.getNames());
        assertNotNull(dinfo.getNames());
        assertTrue(
            dinfo.getDataRangeForVisibleIndex(0).equals(
                new DataRange(0,0)));
    }

    public void testMethodsInheritedFromAbstactHCClusteringInfo() {

        DummyHCClusteringInfo dinfo =
            new DummyHCClusteringInfo(this.names, this.location);

        //testing getName()-methdod
        String s = dinfo.getName(new DataRange(1,1));
        assertTrue("names2".equals(s));
        s = dinfo.getName(new DataRange(0,0));
        assertTrue("names1".equals(s));
        s = dinfo.getName(new DataRange(0,1));
        assertTrue("names1 - names2".equals(s));
        s = dinfo.getName(new DataRange(1,0));
        assertTrue("[]".equals(s));
        s = dinfo.getName(new DataRange(3,4));
        assertTrue("3 - 4".equals(s));
        s = dinfo.getName(new DataRange(3,3));
        assertTrue("3".equals(s));
        s = dinfo.getName(null);
        assertTrue("[]".equals(s));

        //testing getLocation()
        assertTrue(dinfo.getLocation() == 1);

    }
 /**
     * Runs the test suite using JUnit's text-based runner.
     *
     * @param args  ignored.
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
}