/* ======================================================================= 
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */

package org.jfree.chart.labels;

import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.data.hc.HeatMap;
import org.jfree.data.hc.DataRange;

/**
 * A standard tool tip generator to be used with a {@link org.jfree.chart.plot.HCPlot}.
 * @author  viski project
 */
public class StandardHCToolTipGenerator implements HCToolTipGenerator {


    /** 
     * Creates a new tool tip generator.
     */
    public StandardHCToolTipGenerator() {
        ;
    }
    
    /**
     * Generates a tooltip text string for a particular clustering tree node.
     *
     * @param node  HCTreeNodeInfo for the node used.
     *
     * @return The tooltip text.
     */
    public String generateToolTip(HCTreeNodeInfo node) {
	return node.toString();
    }

    /**
     * Generates a tooltip text string for a particular heatmap block.
     *
     * @param heatmap  the HeatMap.
     * @param columnRange  the columns displayed in the block.
     * @param rowRange  the rows displayed in the block.
     *
     * @return The tooltip text.
     */
    public String generateToolTip(
	    HeatMap heatmap,
	    DataRange rowRange,
	    DataRange columnRange
    ) {
	int minRow;
	int maxRow;
	int minColumn;
	int maxColumn;
	int rowCounter;
	int columnCounter;
	int blockCount;
	double averageValue;

	try {
	    minRow = rowRange.getLeftBound();
	    maxRow = rowRange.getRightBound();
	    minColumn = columnRange.getLeftBound();
	    maxColumn = columnRange.getRightBound();
	} catch (Exception e) {
	    return "This block contains no data.";
	}

	if ((minRow == maxRow) && (minColumn == maxColumn)) {

	    return "(" + minRow + "," + minColumn + ") = "
		+ heatmap.get(minRow,minColumn);
	}

	for (
	    averageValue = 0, blockCount = 0, rowCounter = minRow;
	    rowCounter <= maxRow;
	    rowCounter++
	) {
	    for (
		columnCounter = minColumn;
		columnCounter <= maxColumn;
		columnCounter++, blockCount++
	    ) {
		averageValue += heatmap.get(rowCounter,columnCounter);
	    }
	}
	averageValue = averageValue/blockCount;

	return "(" + minRow + "," + minColumn + ") .. "
	    + "(" + maxRow + "," + maxColumn + ") = "
	    + averageValue + " (contains " + blockCount + " blocks)";

    }

}

