package org.jfree.chart.entity.junit;

import java.awt.geom.Area;
import java.awt.Shape;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.HCTreeNodeEntity;
import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.chart.plot.StandardHCClusteringInfo;


/**
 * Tests for the {@link org.jfree.chart.entity.HCTreeNodeEntity} class.
 */
public class HCTreeNodeEntityTests extends TestCase {


    /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(HCTreeNodeEntityTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public HCTreeNodeEntityTests(String name) {
        super(name);
    }


   /**
    * Does the tests.
    */ 
   public void testEntity(){

	HCTreeNode node = new HCTreeNode(2.0);
	StandardHCClusteringInfo clusteringInfo = new StandardHCClusteringInfo(node, new String[1], 1);
	
	HCTreeNodeInfo info = new HCTreeNodeInfo(clusteringInfo, node);

	Rectangle subtreearea = new Rectangle();
	Point center = new Point();

	HCTreeNodeEntity item = new HCTreeNodeEntity(new Area(), "tooltip", "url", center, subtreearea, info);


	assertEquals(item.getSubTreeArea(), subtreearea);
	assertEquals(item.getCenter(), center);
	assertEquals(item.getHCTreeNodeInfo(), info);

   }

   /**
    * Tests wierd parameter values.
    */
   public void testWrong(){
	
	HCTreeNode node = new HCTreeNode(2.0);
	StandardHCClusteringInfo clusteringInfo = new StandardHCClusteringInfo(node, new String[1], 1);
	HCTreeNodeInfo info = new HCTreeNodeInfo(clusteringInfo, node);
	Rectangle subtreearea = new Rectangle();
	Point center = new Point();


	HCTreeNodeEntity item = new HCTreeNodeEntity(new Area(), "tooltip", "url", center, subtreearea, info);

	// test null values
	try {
	  item = new HCTreeNodeEntity(new Area(), "tooltip", "url", center, subtreearea, null);
	  assertEquals(item.getHCTreeNodeInfo(),null);
	  assertTrue(true);
	} catch (Exception e){;}

	try {
	  item = new HCTreeNodeEntity(new Area(), "tooltip", "url", center, null, info);
	  assertEquals(item.getSubTreeArea(), null);
	  assertTrue(true);
	} catch (Exception e){;}

	try {
	  item = new HCTreeNodeEntity(new Area(), "tooltip", "url", null, subtreearea, info);
	  assertEquals(item.getCenter(), null);
	  assertTrue(true);
	} catch (Exception e){;}

	try {
	  item = new HCTreeNodeEntity(null, "tooltip", "url", center, subtreearea, info);
	  assertTrue(false);
	} catch (Exception e){;}

   }	
}
