/* ======================================================================= 
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */

package org.jfree.chart.editor;

import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Point2D;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.ResourceBundle;
import java.util.Set;
import java.util.Iterator;

import java.lang.IllegalArgumentException;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jfree.ui.RectangleEdge;
import org.jfree.ui.PaintSample;

import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.axis.HeatMapAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.entity.HCTreeNodeEntity;
import org.jfree.chart.entity.HeatMapBlockEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.HCToolTipGenerator;
import org.jfree.chart.plot.GradientColorPalette;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.RendererState;
import org.jfree.data.hc.HCDataset;
import org.jfree.data.hc.HeatMap;
import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.HCTreeNode;

/**
 * xxx
 *
 * @author viski project.
 */
public class GradientColorPaletteEditor
    extends JPanel
    implements ActionListener, ChangeListener {

    private JCheckBox logarithmicCB;
    private GradientColorPalette palette;
    private ColorInfo[] colors;

    public GradientColorPaletteEditor () {

	super();
	this.palette = null;
	this.colors = null;
	
    }

    public void setColoring (GradientColorPalette palette) {

	this.palette = palette;

    }

    /**
     * Listens for checkbox events.
     *
     * @param e  the event.
     */
    public void stateChanged(ChangeEvent e) {

        if (e.getSource() == this.logarithmicCB) {

            boolean value = this.logarithmicCB.isSelected();
            this.palette.setLinear(!value);

	}

    }

    /**
     * Listens button events
     *
     * @param e  the event.
     */
    public void actionPerformed(ActionEvent e) {

	int i;
	Color color;
        ResourceBundle lr = ResourceBundle.getBundle(
		"org.jfree.chart.editor.LocalizationBundle");

	if (colors == null) return;

	for (i = 0; i < this.colors.length; i++) {

	    if (e.getSource() == this.colors[i].button) {
		color = this.palette.getKeyColor(this.colors[i].value);

		color = JColorChooser.showDialog(
		    this, lr.getString("Change_color")+i, color
		);
		if (color != null) {
		    this.colors[i].sample.setPaint( color);
		    this.palette.setKeyColor(this.colors[i].value, color);
		}
	    }

	}

    }
    /**
     * Creates a new JPanel for adjusting heatmap colors.
     *
     * @return  The panel.
     */
    public JPanel getPanel() {
        ResourceBundle lr = ResourceBundle.getBundle(
		"org.jfree.chart.editor.LocalizationBundle");
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();

	Set keyColors = this.palette.getKeyColors();
	Iterator iterator = keyColors.iterator();
	int i;

        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));

        c.fill = GridBagConstraints.VERTICAL;
        c.insets = new Insets(5,2,5,2);

	c.gridx = 0;
	c.gridy = 0;

	colors = new ColorInfo[keyColors.size()];

	i = 0;
	while (iterator.hasNext()) {

	    ColorInfo color = new ColorInfo();
	    color.value = ((Double)(iterator.next())).doubleValue();
	    
	    c.gridx=0;
	    String nameOfColor;
	    if (i==0) nameOfColor
		= lr.getString("Color_for_values_below")+color.value;
	    else if (!iterator.hasNext()) nameOfColor
		= lr.getString("Color_for_values_above")+color.value;
	    else nameOfColor
		= lr.getString("Color_for_value")+color.value;
	    panel.add(new JLabel(nameOfColor),c);

	    c.gridx=1;
	    color.sample
		= new PaintSample(this.palette.getColor(color.value));
	    panel.add(color.sample,c);

	    c.gridx=2;
	    color.button = new JButton(lr.getString("Change"));
	    panel.add(color.button,c);
	    color.button.addActionListener(this);

	    this.colors[i] = color;

	    c.gridy++;
	    i++;

	}

	c.gridx=0;
	this.logarithmicCB = new JCheckBox(
	    lr.getString("Use_logarithmic_scale"),
	    !this.palette.isLinear()
	);
	this.logarithmicCB.addChangeListener(this);
	panel.add(this.logarithmicCB,c);
        return panel;
    }

    private class ColorInfo {

	private PaintSample sample;
	private JButton button;
	private double value;
    }

}

