/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.util.InetAddressUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdGenerator {
    private static final Log LOG = LogFactory.getLog(IdGenerator.class);
    private static final String UNIQUE_STUB;
    private static int instanceCount;
    private static String hostName;
    private String seed;
    private AtomicLong sequence = new AtomicLong(1L);
    private int length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdGenerator(String prefix) {
        String string = UNIQUE_STUB;
        synchronized (string) {
            this.seed = prefix + UNIQUE_STUB + instanceCount++ + ":";
            this.length = this.seed.length() + "9223372036854775807".length();
        }
    }

    public IdGenerator() {
        this("ID:" + hostName);
    }

    public static String getHostName() {
        return hostName;
    }

    public synchronized String generateId() {
        StringBuilder sb = new StringBuilder(this.length);
        sb.append(this.seed);
        sb.append(this.sequence.getAndIncrement());
        return sb.toString();
    }

    public String generateSanitizedId() {
        String result = this.generateId();
        result = result.replace(':', '-');
        result = result.replace('_', '-');
        result = result.replace('.', '-');
        return result;
    }

    public static String getSeedFromId(String id) {
        int index;
        String result = id;
        if (id != null && (index = id.lastIndexOf(58)) > 0 && index + 1 < id.length()) {
            result = id.substring(0, index + 1);
        }
        return result;
    }

    public static long getSequenceFromId(String id) {
        int index;
        long result = -1L;
        if (id != null && (index = id.lastIndexOf(58)) > 0 && index + 1 < id.length()) {
            String numStr = id.substring(index + 1, id.length());
            result = Long.parseLong(numStr);
        }
        return result;
    }

    public static int compare(String id1, String id2) {
        int result = -1;
        String seed1 = IdGenerator.getSeedFromId(id1);
        String seed2 = IdGenerator.getSeedFromId(id2);
        if (seed1 != null && seed2 != null && (result = seed1.compareTo(seed2)) == 0) {
            long count1 = IdGenerator.getSequenceFromId(id1);
            long count2 = IdGenerator.getSequenceFromId(id2);
            result = (int)(count1 - count2);
        }
        return result;
    }

    static {
        String stub = "";
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            try {
                hostName = InetAddressUtil.getLocalHostName();
                ServerSocket ss = new ServerSocket(0);
                stub = "-" + ss.getLocalPort() + "-" + System.currentTimeMillis() + "-";
                Thread.sleep(100L);
                ss.close();
            }
            catch (Exception ioe) {
                LOG.warn((Object)"could not generate unique stub", (Throwable)ioe);
            }
        } else {
            hostName = "localhost";
            stub = "-1-" + System.currentTimeMillis() + "-";
        }
        UNIQUE_STUB = stub;
    }
}

