/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCMessageStore;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCTopicMessageStore
extends JDBCMessageStore
implements TopicMessageStore {
    private static final Log LOG = LogFactory.getLog(JDBCTopicMessageStore.class);
    private Map<String, LastRecovered> subscriberLastRecoveredMap = new ConcurrentHashMap<String, LastRecovered>();

    public JDBCTopicMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, ActiveMQTopic topic, ActiveMQMessageAudit audit) {
        super(persistenceAdapter, adapter, wireFormat, topic, audit);
    }

    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
        if (ack != null && ack.isUnmatchedAck()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("ignoring unmatched selector ack for: " + messageId + ", cleanup will get to this message after subsequent acks.");
            }
            return;
        }
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            long[] res = this.adapter.getStoreSequenceId(c, this.destination, messageId);
            if (this.isPrioritizedMessages()) {
                this.adapter.doSetLastAckWithPriority(c, this.destination, clientId, subscriptionName, res[0], res[1]);
            } else {
                this.adapter.doSetLastAck(c, this.destination, clientId, subscriptionName, res[0], res[1]);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(clientId + ":" + subscriptionName + " ack, seq: " + res[0] + ", priority: " + res[1]);
            }
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to store acknowledgment for: " + clientId + " on message " + messageId + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void recoverSubscription(String clientId, String subscriptionName, final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            this.adapter.doRecoverSubscription(c, this.destination, clientId, subscriptionName, new JDBCMessageRecoveryListener(){

                public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
                    Message msg = (Message)JDBCTopicMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    return listener.recoverMessage(msg);
                }

                public boolean recoverMessageReference(String reference) throws Exception {
                    return listener.recoverMessageReference(new MessageId(reference));
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to recover subscription: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recoverNextMessages(String clientId, String subscriptionName, int maxReturned, final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        if (!this.subscriberLastRecoveredMap.containsKey(key)) {
            this.subscriberLastRecoveredMap.put(key, new LastRecovered());
        }
        final LastRecovered lastRecovered = this.subscriberLastRecoveredMap.get(key);
        try {
            JDBCMessageRecoveryListener jdbcListener = new JDBCMessageRecoveryListener(){

                public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
                    if (listener.hasSpace()) {
                        Message msg = (Message)JDBCTopicMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                        msg.getMessageId().setBrokerSequenceId(sequenceId);
                        if (listener.recoverMessage(msg)) {
                            lastRecovered.update(sequenceId, msg);
                            return true;
                        }
                    }
                    return false;
                }

                public boolean recoverMessageReference(String reference) throws Exception {
                    return listener.recoverMessageReference(new MessageId(reference));
                }
            };
            if (this.isPrioritizedMessages()) {
                this.adapter.doRecoverNextMessagesWithPriority(c, this.destination, clientId, subscriptionName, lastRecovered.sequence, lastRecovered.priority, maxReturned, jdbcListener);
            } else {
                this.adapter.doRecoverNextMessages(c, this.destination, clientId, subscriptionName, lastRecovered.sequence, 0L, maxReturned, jdbcListener);
            }
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
        }
        finally {
            c.close();
        }
    }

    public void resetBatching(String clientId, String subscriptionName) {
        this.subscriberLastRecoveredMap.remove(this.getSubscriptionKey(clientId, subscriptionName));
    }

    public void addSubsciption(SubscriptionInfo subscriptionInfo, boolean retroactive) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            c = this.persistenceAdapter.getTransactionContext();
            this.adapter.doSetSubscriberEntry(c, subscriptionInfo, retroactive, this.isPrioritizedMessages());
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to lookup subscription for info: " + subscriptionInfo.getClientId() + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            SubscriptionInfo subscriptionInfo = this.adapter.doGetSubscriberEntry(c, this.destination, clientId, subscriptionName);
            return subscriptionInfo;
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to lookup subscription for: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            this.adapter.doDeleteSubscription(c, this.destination, clientId, subscriptionName);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to remove subscription for: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
            this.resetBatching(clientId, subscriptionName);
        }
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            SubscriptionInfo[] subscriptionInfoArray = this.adapter.doGetAllSubscriptions(c, this.destination);
            return subscriptionInfoArray;
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to lookup subscriptions. Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        int result = 0;
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            result = this.adapter.doGetDurableSubscriberMessageCount(c, this.destination, clientId, subscriberName, this.isPrioritizedMessages());
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to get Message Count: " + clientId + ". Reason: " + e, e);
        }
        finally {
            c.close();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(clientId + ":" + subscriberName + ", messageCount: " + result);
        }
        return result;
    }

    protected String getSubscriptionKey(String clientId, String subscriberName) {
        String result = clientId + ":";
        result = result + (subscriberName != null ? subscriberName : "NOT_SET");
        return result;
    }

    private class LastRecovered {
        long sequence = 0L;
        byte priority = (byte)9;

        private LastRecovered() {
        }

        public void update(long sequence, Message msg) {
            this.sequence = sequence;
            this.priority = msg.getPriority();
        }

        public String toString() {
            return "" + this.sequence + ":" + this.priority;
        }
    }
}

