/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import org.broad.tribble.util.BlockCompressedInputStream;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class TabixReader {
    private String mFn;
    BlockCompressedInputStream mFp;
    private int mPreset;
    private int mSc;
    private int mBc;
    private int mEc;
    private int mMeta;
    private int mSkip;
    private String[] mSeq;
    public HashMap<String, Integer> mChr2tid;
    private static int MAX_BIN = 37450;
    private static int TAD_MIN_CHUNK_GAP = 32768;
    private static int TAD_LIDX_SHIFT = 14;
    protected TIndex[] mIndex;

    private static boolean less64(long u, long v) {
        return u < v ^ u < 0L ^ v < 0L;
    }

    public TabixReader(String fn) throws IOException {
        this.mFn = fn;
        this.mFp = new BlockCompressedInputStream(SeekableStreamFactory.getStreamFor(fn));
        this.readIndex();
    }

    public TabixReader(String fn, SeekableStream stream) throws IOException {
        this.mFn = fn;
        this.mFp = new BlockCompressedInputStream(stream);
        this.readIndex();
    }

    private static int reg2bins(int beg, int _end, int[] list) {
        int i = 0;
        int end = _end;
        if (beg >= end) {
            return 0;
        }
        if (end >= 0x20000000) {
            end = 0x20000000;
        }
        --end;
        list[i++] = 0;
        int k = 1 + (beg >> 26);
        while (k <= 1 + (end >> 26)) {
            list[i++] = k++;
        }
        k = 9 + (beg >> 23);
        while (k <= 9 + (end >> 23)) {
            list[i++] = k++;
        }
        k = 73 + (beg >> 20);
        while (k <= 73 + (end >> 20)) {
            list[i++] = k++;
        }
        k = 585 + (beg >> 17);
        while (k <= 585 + (end >> 17)) {
            list[i++] = k++;
        }
        k = 4681 + (beg >> 14);
        while (k <= 4681 + (end >> 14)) {
            list[i++] = k++;
        }
        return i;
    }

    public static int readInt(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long readLong(InputStream is) throws IOException {
        byte[] buf = new byte[8];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static String readLine(InputStream is) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        while ((c = is.read()) >= 0 && c != 10) {
            buf.append((char)c);
        }
        if (c < 0) {
            return null;
        }
        return buf.toString();
    }

    public void readIndex(SeekableStream fp) throws IOException {
        if (fp == null) {
            return;
        }
        BlockCompressedInputStream is = new BlockCompressedInputStream(fp);
        byte[] buf = new byte[4];
        is.read(buf, 0, 4);
        this.mSeq = new String[TabixReader.readInt(is)];
        this.mChr2tid = new HashMap();
        this.mPreset = TabixReader.readInt(is);
        this.mSc = TabixReader.readInt(is);
        this.mBc = TabixReader.readInt(is);
        this.mEc = TabixReader.readInt(is);
        this.mMeta = TabixReader.readInt(is);
        this.mSkip = TabixReader.readInt(is);
        int l = TabixReader.readInt(is);
        buf = new byte[l];
        is.read(buf);
        int k = 0;
        int j = 0;
        int i = 0;
        while (i < buf.length) {
            if (buf[i] == 0) {
                byte[] b = new byte[i - j];
                System.arraycopy(buf, j, b, 0, b.length);
                String s = new String(b);
                this.mChr2tid.put(s, k);
                this.mSeq[k++] = s;
                j = i + 1;
            }
            ++i;
        }
        this.mIndex = new TIndex[this.mSeq.length];
        i = 0;
        while (i < this.mSeq.length) {
            int n_bin = TabixReader.readInt(is);
            this.mIndex[i] = new TIndex();
            this.mIndex[i].b = new HashMap();
            j = 0;
            while (j < n_bin) {
                int bin = TabixReader.readInt(is);
                TPair64[] chunks = new TPair64[TabixReader.readInt(is)];
                k = 0;
                while (k < chunks.length) {
                    long u = TabixReader.readLong(is);
                    long v = TabixReader.readLong(is);
                    chunks[k] = new TPair64(u, v);
                    ++k;
                }
                this.mIndex[i].b.put(bin, chunks);
                ++j;
            }
            this.mIndex[i].l = new long[TabixReader.readInt(is)];
            k = 0;
            while (k < this.mIndex[i].l.length) {
                this.mIndex[i].l[k] = TabixReader.readLong(is);
                ++k;
            }
            ++i;
        }
        is.close();
    }

    public void readIndex() throws IOException {
        this.readIndex(SeekableStreamFactory.getStreamFor(String.valueOf(this.mFn) + ".tbi"));
    }

    public String readLine() throws IOException {
        return TabixReader.readLine(this.mFp);
    }

    private int chr2tid(String chr) {
        if (this.mChr2tid.containsKey(chr)) {
            return this.mChr2tid.get(chr);
        }
        return -1;
    }

    public int[] parseReg(String reg) {
        String chr;
        int[] ret = new int[3];
        int colon = reg.indexOf(58);
        int hyphen = reg.indexOf(45);
        String string = chr = colon >= 0 ? reg.substring(0, colon) : reg;
        ret[1] = colon >= 0 ? Integer.parseInt(reg.substring(colon + 1, hyphen >= 0 ? hyphen : reg.length())) - 1 : 0;
        ret[2] = hyphen >= 0 ? Integer.parseInt(reg.substring(hyphen + 1)) : Integer.MAX_VALUE;
        ret[0] = this.chr2tid(chr);
        return ret;
    }

    private TIntv getIntv(String s) {
        TIntv intv = new TIntv();
        int col = 0;
        int end = 0;
        int beg = 0;
        while ((end = s.indexOf(9, beg)) >= 0 || end == -1) {
            if (++col == this.mSc) {
                intv.tid = this.chr2tid(end != -1 ? s.substring(beg, end) : s.substring(beg));
            } else if (col == this.mBc) {
                intv.end = Integer.parseInt(end != -1 ? s.substring(beg, end) : s.substring(beg));
                intv.beg = intv.end++;
                if ((this.mPreset & 0x10000) == 0) {
                    --intv.beg;
                }
                if (intv.beg < 0) {
                    intv.beg = 0;
                }
                if (intv.end < 1) {
                    intv.end = 1;
                }
            } else if ((this.mPreset & 0xFFFF) == 0) {
                if (col == this.mEc) {
                    intv.end = Integer.parseInt(end != -1 ? s.substring(beg, end) : s.substring(beg));
                }
            } else if ((this.mPreset & 0xFFFF) == 1) {
                if (col == 6) {
                    int l = 0;
                    String cigar = s.substring(beg, end);
                    int j = 0;
                    int i = 0;
                    while (i < cigar.length()) {
                        if (cigar.charAt(i) > '9') {
                            char op = cigar.charAt(i);
                            if (op == 'M' || op == 'D' || op == 'N') {
                                l += Integer.parseInt(cigar.substring(j, i));
                            }
                            j = i + 1;
                        }
                        ++i;
                    }
                    intv.end = intv.beg + l;
                }
            } else if ((this.mPreset & 0xFFFF) == 2) {
                String alt;
                String string = alt = end >= 0 ? s.substring(beg, end) : s.substring(beg);
                if (col == 4) {
                    if (alt.length() > 0) {
                        intv.end = intv.beg + alt.length();
                    }
                } else if (col == 8) {
                    int e_off = -1;
                    int i = alt.indexOf("END=");
                    if (i == 0) {
                        e_off = 4;
                    } else if (i > 0 && (i = alt.indexOf(";END=")) >= 0) {
                        e_off = i + 5;
                    }
                    if (e_off > 0) {
                        i = alt.indexOf(";", e_off);
                        intv.end = Integer.parseInt(i > e_off ? alt.substring(e_off, i) : alt.substring(e_off));
                    }
                }
            }
            if (end == -1) break;
            beg = end + 1;
        }
        return intv;
    }

    public Iterator query(int tid, int beg, int end) {
        TPair64[] chunks;
        TIndex idx = this.mIndex[tid];
        int[] bins = new int[MAX_BIN];
        int n_bins = TabixReader.reg2bins(beg, end, bins);
        long min_off = idx.l.length > 0 ? (beg >> TAD_LIDX_SHIFT >= idx.l.length ? idx.l[idx.l.length - 1] : idx.l[beg >> TAD_LIDX_SHIFT]) : 0L;
        int n_off = 0;
        int i = 0;
        while (i < n_bins) {
            chunks = idx.b.get(bins[i]);
            if (chunks != null) {
                n_off += chunks.length;
            }
            ++i;
        }
        if (n_off == 0) {
            return null;
        }
        Object[] off = new TPair64[n_off];
        n_off = 0;
        i = 0;
        while (i < n_bins) {
            chunks = idx.b.get(bins[i]);
            if (chunks != null) {
                int j = 0;
                while (j < chunks.length) {
                    if (TabixReader.less64(min_off, chunks[j].v)) {
                        off[n_off++] = new TPair64(chunks[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Arrays.sort(off, 0, n_off);
        i = 1;
        int l = 0;
        while (i < n_off) {
            if (TabixReader.less64(((TPair64)off[l]).v, ((TPair64)off[i]).v)) {
                ((TPair64)off[++l]).u = ((TPair64)off[i]).u;
                ((TPair64)off[l]).v = ((TPair64)off[i]).v;
            }
            ++i;
        }
        n_off = l + 1;
        i = 1;
        while (i < n_off) {
            if (!TabixReader.less64(((TPair64)off[i - 1]).v, ((TPair64)off[i]).u)) {
                ((TPair64)off[i - 1]).v = ((TPair64)off[i]).u;
            }
            ++i;
        }
        i = 1;
        l = 0;
        while (i < n_off) {
            if (((TPair64)off[l]).v >> 16 == ((TPair64)off[i]).u >> 16) {
                ((TPair64)off[l]).v = ((TPair64)off[i]).v;
            } else {
                ((TPair64)off[++l]).u = ((TPair64)off[i]).u;
                ((TPair64)off[l]).v = ((TPair64)off[i]).v;
            }
            ++i;
        }
        n_off = l + 1;
        TPair64[] ret = new TPair64[n_off];
        i = 0;
        while (i < n_off) {
            if (off[i] != null) {
                ret[i] = new TPair64(((TPair64)off[i]).u, ((TPair64)off[i]).v);
            }
            ++i;
        }
        if (ret.length == 0 || ret.length == 1 && ret[0] == null) {
            return null;
        }
        return new Iterator(tid, beg, end, ret);
    }

    public Iterator query(String reg) {
        int[] x = this.parseReg(reg);
        return this.query(x[0], x[1], x[2]);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java -cp .:sam.jar TabixReader <in.gz> [region]");
            System.exit(1);
        }
        try {
            TabixReader tr = new TabixReader(args[0]);
            if (args.length == 1) {
                String s;
                while ((s = tr.readLine()) != null) {
                    System.out.println(s);
                }
            } else {
                String s;
                Iterator iter = tr.query(args[1]);
                while ((s = iter.next()) != null) {
                    System.out.println(s);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.mFp != null) {
            try {
                this.mFp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class Iterator {
        private int i = -1;
        private int n_seeks = 0;
        private int tid;
        private int beg;
        private int end;
        private TPair64[] off;
        private long curr_off = 0L;
        private boolean iseof = false;

        public Iterator(int _tid, int _beg, int _end, TPair64[] _off) {
            this.off = _off;
            this.tid = _tid;
            this.beg = _beg;
            this.end = _end;
        }

        public String next() throws IOException {
            block5: {
                String s;
                if (this.iseof) {
                    return null;
                }
                while (true) {
                    if (this.curr_off == 0L || !TabixReader.less64(this.curr_off, this.off[this.i].v)) {
                        if (this.i == this.off.length - 1) break block5;
                        if (this.i >= 0) assert (this.curr_off == this.off[this.i].v);
                        if (this.i < 0 || this.off[this.i].v != this.off[this.i + 1].u) {
                            TabixReader.this.mFp.seek(this.off[this.i + 1].u);
                            this.curr_off = TabixReader.this.mFp.getFilePointer();
                            ++this.n_seeks;
                        }
                        ++this.i;
                    }
                    if ((s = TabixReader.readLine(TabixReader.this.mFp)) == null) break block5;
                    char[] str = s.toCharArray();
                    this.curr_off = TabixReader.this.mFp.getFilePointer();
                    if (str.length == 0 || str[0] == TabixReader.this.mMeta) continue;
                    TIntv intv = TabixReader.this.getIntv(s);
                    if (intv.tid != this.tid || intv.beg >= this.end) break block5;
                    if (intv.end > this.beg && intv.beg < this.end) break;
                }
                return s;
            }
            this.iseof = true;
            return null;
        }
    }

    protected class TIndex {
        HashMap<Integer, TPair64[]> b;
        long[] l;

        protected TIndex() {
        }
    }

    private class TIntv {
        int tid;
        int beg;
        int end;

        private TIntv() {
        }
    }

    protected class TPair64
    implements Comparable<TPair64> {
        long u;
        long v;

        public TPair64(long _u, long _v) {
            this.u = _u;
            this.v = _v;
        }

        public TPair64(TPair64 p) {
            this.u = p.u;
            this.v = p.v;
        }

        @Override
        public int compareTo(TPair64 p) {
            return this.u == p.u ? 0 : (this.u < p.u ^ this.u < 0L ^ p.u < 0L ? -1 : 1);
        }
    }
}

