/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.IOException;
import java.io.InputStream;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.Positional;

public class PositionalBufferedStream
extends InputStream
implements Positional {
    final InputStream is;
    final byte[] buffer;
    int nextChar;
    int nChars;
    long position;

    public PositionalBufferedStream(InputStream is) {
        this(is, 512000);
    }

    public PositionalBufferedStream(InputStream is, int bufferSize) {
        this.is = is;
        this.buffer = new byte[bufferSize];
        this.nChars = 0;
        this.nextChar = 0;
    }

    @Override
    public final long getPosition() {
        return this.position;
    }

    @Override
    public final int read() throws IOException {
        if (this.peek() < 0) {
            return -1;
        }
        ++this.position;
        return PositionalBufferedStream.byteToInt(this.buffer[this.nextChar++]);
    }

    @Override
    public final boolean isDone() throws IOException {
        return this.nChars == -1 || this.peek() == -1;
    }

    @Override
    public final int peek() throws IOException {
        if (this.nChars < 0) {
            return -1;
        }
        if (this.nextChar == this.nChars && this.fill() < 0) {
            return -1;
        }
        return PositionalBufferedStream.byteToInt(this.buffer[this.nextChar]);
    }

    private int fill() throws IOException {
        this.nChars = this.is.read(this.buffer);
        this.nextChar = 0;
        return this.nChars;
    }

    @Override
    public final long skip(long nBytes) throws IOException {
        long remainingToSkip = nBytes;
        while (remainingToSkip > 0L && !this.isDone()) {
            long bytesLeftInBuffer = this.nChars - this.nextChar;
            if (remainingToSkip > bytesLeftInBuffer) {
                remainingToSkip -= bytesLeftInBuffer;
                this.fill();
                continue;
            }
            this.nextChar = (int)((long)this.nextChar + remainingToSkip);
            remainingToSkip = 0L;
        }
        long actuallySkipped = nBytes - remainingToSkip;
        this.position += actuallySkipped;
        return actuallySkipped;
    }

    @Override
    public final void close() {
        try {
            this.is.close();
        }
        catch (IOException ex) {
            new TribbleException("Failed to close PositionalBufferedStream", ex);
        }
    }

    private static final int byteToInt(byte b) {
        return b & 0xFF;
    }
}

