/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.linear;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.bed.BEDCodec;
import org.broad.tribble.bed.BEDFeature;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.index.linear.LinearIndex;
import org.junit.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class LinearIndexTest {
    private static final File RANDOM_FILE = new File("notMeaningful");
    private static final Block CHR1_B1 = new Block(1L, 10);
    private static final Block CHR1_B2 = new Block(10L, 20);
    private static final Block CHR1_B3 = new Block(20L, 30);
    private static final Block CHR2_B1 = new Block(1L, 100);
    private static final Block CHR2_B2 = new Block(100L, 200);
    private LinearIndex idx;
    File fakeBed = new File("test/data/fakeBed.bed");

    @BeforeTest
    public void setup() {
        this.idx = LinearIndexTest.createTestIndex();
    }

    private static LinearIndex createTestIndex() {
        LinearIndex.ChrIndex chr1 = new LinearIndex.ChrIndex("chr1", 10);
        chr1.addBlock(CHR1_B1);
        chr1.addBlock(CHR1_B2);
        chr1.addBlock(CHR1_B3);
        chr1.updateLongestFeature(1);
        LinearIndex.ChrIndex chr2 = new LinearIndex.ChrIndex("chr2", 100);
        chr2.addBlock(CHR2_B1);
        chr2.addBlock(CHR2_B2);
        chr2.updateLongestFeature(50);
        List<LinearIndex.ChrIndex> indices = Arrays.asList(chr1, chr2);
        return new LinearIndex(indices, RANDOM_FILE);
    }

    @Test
    public void testBasicFeatures() {
        org.testng.Assert.assertEquals((Object)this.idx.getChrIndexClass(), LinearIndex.ChrIndex.class);
        org.testng.Assert.assertEquals((int)this.idx.getType(), (int)IndexFactory.IndexType.LINEAR.getHeaderValue());
        org.testng.Assert.assertFalse((boolean)this.idx.hasFileSize());
        org.testng.Assert.assertFalse((boolean)this.idx.hasTimestamp());
        org.testng.Assert.assertFalse((boolean)this.idx.hasMD5());
        org.testng.Assert.assertTrue((boolean)this.idx.isCurrentVersion());
        org.testng.Assert.assertNotNull(this.idx.getSequenceNames());
        org.testng.Assert.assertEquals((int)this.idx.getSequenceNames().size(), (int)2);
        org.testng.Assert.assertTrue((boolean)this.idx.getSequenceNames().contains("chr1"));
        org.testng.Assert.assertTrue((boolean)this.idx.getSequenceNames().contains("chr2"));
        org.testng.Assert.assertTrue((boolean)this.idx.containsChromosome("chr1"));
        org.testng.Assert.assertTrue((boolean)this.idx.containsChromosome("chr2"));
        org.testng.Assert.assertFalse((boolean)this.idx.containsChromosome("chr3"));
        org.testng.Assert.assertEquals((Object)this.idx.getIndexedFile(), (Object)new File(RANDOM_FILE.getAbsolutePath()));
        org.testng.Assert.assertNotNull(this.idx.getBlocks("chr1"));
        org.testng.Assert.assertEquals((int)this.idx.getBlocks("chr1").size(), (int)3);
        org.testng.Assert.assertNotNull(this.idx.getBlocks("chr2"));
        org.testng.Assert.assertEquals((int)this.idx.getBlocks("chr2").size(), (int)2);
    }

    @Test
    public void testEquals() {
        LinearIndex idx2 = LinearIndexTest.createTestIndex();
        org.testng.Assert.assertEquals((Object)this.idx, (Object)this.idx, (String)"Identical indices are equal");
        org.testng.Assert.assertTrue((boolean)this.idx.equalsIgnoreProperties(this.idx), (String)"Identical indices are equalIgnoreTimeStamp");
        org.testng.Assert.assertTrue((boolean)this.idx.equalsIgnoreProperties(idx2), (String)"Indices constructed the same are equalIgnoreTimeStamp");
        idx2.setTS(123456789L);
        org.testng.Assert.assertNotSame((Object)this.idx, (Object)idx2, (String)"Indices with different timestamps are not the same");
        org.testng.Assert.assertTrue((boolean)this.idx.equalsIgnoreProperties(idx2), (String)"Indices with different timestamps are equalIgnoreTimeStamp");
    }

    public void testBasicQuery() {
        this.testQuery("chr1", 1, 1, CHR1_B1);
        this.testQuery("chr1", 1, 2, CHR1_B1);
        this.testQuery("chr1", 1, 9, CHR1_B1);
        this.testQuery("chr1", 10, 10, CHR1_B1);
        this.testQuery("chr1", 10, 11, CHR1_B1, CHR1_B2);
        this.testQuery("chr1", 11, 11, CHR1_B2);
        this.testQuery("chr1", 11, 12, CHR1_B2);
        this.testQuery("chr1", 11, 19, CHR1_B2);
        this.testQuery("chr1", 10, 19, CHR1_B1, CHR1_B2);
        this.testQuery("chr1", 10, 21, CHR1_B1, CHR1_B2, CHR1_B3);
        this.testQuery("chr1", 25, 30, CHR1_B3);
        this.testQuery("chr1", 35, 40, new Block[0]);
        this.testQuery("chr2", 1, 1, CHR2_B1);
        this.testQuery("chr2", 100, 100, CHR2_B1);
        this.testQuery("chr2", 125, 125, CHR2_B1, CHR2_B2);
        this.testQuery("chr2", 151, 151, CHR2_B2);
        this.testQuery("chr2", 249, 249, CHR2_B2);
        this.testQuery("chr2", 251, 251, new Block[0]);
    }

    private final void testQuery(String chr, int start, int stop, Block ... expectedBlocksArray) {
        List<Block> qBlocks = this.idx.getBlocks(chr, start, stop);
        List<Block> eBlocks = Arrays.asList(expectedBlocksArray);
        org.testng.Assert.assertEquals((int)qBlocks.size(), (int)eBlocks.size(), (String)String.format("Query %s:%d-%d returned %d blocks but we only expected %d.", chr, start, stop, qBlocks.size(), eBlocks.size()));
        int i = 0;
        while (i < qBlocks.size()) {
            org.testng.Assert.assertEquals((Object)qBlocks.get(i), (Object)eBlocks.get(i));
            ++i;
        }
    }

    @Test
    public void oneEntryFirstChr() {
        BEDCodec code = new BEDCodec();
        Index index = IndexFactory.createLinearIndex(this.fakeBed, code);
        AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader(this.fakeBed.getAbsolutePath(), (FeatureCodec)code, index);
        try {
            CloseableTribbleIterator it = reader.iterator();
            int count = 0;
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            org.testng.Assert.assertEquals((int)51, (int)count);
        }
        catch (IOException e) {
            org.testng.Assert.fail((String)("Unable to get iterator due to " + e.getMessage()));
        }
    }

    @Test
    public void testOverlappingFeatures() throws Exception {
        BEDFeature feature;
        HashSet<String> names = new HashSet<String>(Arrays.asList("Hs.134602", "Hs.620337", "Hs.609465", "Hs.623987", "Hs.594545", "LONG_FEATURE"));
        String bedFile = "test/data/bed/Unigene.sample.bed";
        String chr = "chr2";
        int start = 179266309;
        int end = 179303488;
        int expectedCount = 6;
        LinearIndex.enableAdaptiveIndexing = false;
        int binSize = 1000;
        Index idx = IndexFactory.createLinearIndex(new File(bedFile), new BEDCodec(), binSize);
        AbstractFeatureReader bfr = AbstractFeatureReader.getFeatureReader(bedFile, (FeatureCodec)new BEDCodec(), idx);
        CloseableTribbleIterator iter = bfr.query(chr, start, end);
        int countInterval = 0;
        while (iter.hasNext()) {
            feature = (BEDFeature)iter.next();
            Assert.assertTrue((feature.getEnd() >= start && feature.getStart() <= end ? 1 : 0) != 0);
            Assert.assertTrue((boolean)names.contains(feature.getName()));
            ++countInterval;
        }
        org.testng.Assert.assertEquals((int)countInterval, (int)expectedCount);
        LinearIndex.enableAdaptiveIndexing = true;
        idx = IndexFactory.createLinearIndex(new File(bedFile), new BEDCodec(), binSize);
        bfr = AbstractFeatureReader.getFeatureReader(bedFile, (FeatureCodec)new BEDCodec(), idx);
        iter = bfr.query(chr, start, end);
        countInterval = 0;
        while (iter.hasNext()) {
            feature = (BEDFeature)iter.next();
            Assert.assertTrue((feature.getEnd() >= start && feature.getStart() <= end ? 1 : 0) != 0);
            Assert.assertTrue((boolean)names.contains(feature.getName()));
            ++countInterval;
        }
        org.testng.Assert.assertEquals((int)countInterval, (int)expectedCount);
    }
}

