/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.bed.BEDCodec;
import org.broad.tribble.example.ExampleBinaryCodec;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BinaryFeaturesTest {
    @DataProvider(name="BinaryFeatureSources")
    public Object[][] createData1() {
        return new Object[][]{{new File("test/data/test.bed"), new BEDCodec()}, {new File("test/data/bed/Unigene.sample.bed"), new BEDCodec()}, {new File("test/data/bed/NA12878.deletions.10kbp.het.gq99.hand_curated.hg19_fixed.bed"), new BEDCodec()}};
    }

    @Test(enabled=true, dataProvider="BinaryFeatureSources")
    public void testBinaryCodec(File source, FeatureCodec<Feature> codec) throws IOException {
        File tmpFile = File.createTempFile("testBinaryCodec", ".binary.bed");
        ExampleBinaryCodec.convertToBinaryTest(source, tmpFile, codec);
        tmpFile.deleteOnExit();
        AbstractFeatureReader originalReader = AbstractFeatureReader.getFeatureReader(source.getAbsolutePath(), codec, false);
        AbstractFeatureReader binaryReader = AbstractFeatureReader.getFeatureReader(tmpFile.getAbsolutePath(), (FeatureCodec)new ExampleBinaryCodec(), false);
        List header = (List)binaryReader.getHeader();
        Assert.assertEquals((int)header.size(), (int)1, (String)"We expect exactly one header line");
        Assert.assertEquals((String)((String)header.get(0)), (String)"# BinaryTestFeature", (String)"Failed to read binary header line");
        CloseableTribbleIterator oit = originalReader.iterator();
        CloseableTribbleIterator bit = binaryReader.iterator();
        while (oit.hasNext()) {
            Feature of = (Feature)oit.next();
            Assert.assertTrue((boolean)bit.hasNext(), (String)"Original iterator has items, but there's no items left in binary iterator");
            Feature bf = (Feature)bit.next();
            Assert.assertEquals((String)bf.getChr(), (String)of.getChr(), (String)"Chr not equal between original and binary encoding");
            Assert.assertEquals((int)bf.getStart(), (int)of.getStart(), (String)"Start not equal between original and binary encoding");
            Assert.assertEquals((int)bf.getEnd(), (int)of.getEnd(), (String)"End not equal between original and binary encoding");
        }
        Assert.assertTrue((!bit.hasNext() ? 1 : 0) != 0, (String)"Original iterator is done, but there's still some data in binary iterator");
        originalReader.close();
        binaryReader.close();
    }
}

