/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.config;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.ConfigurationEntry;
import fi.csc.microarray.config.ConfigurationModule;
import fi.csc.microarray.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationLoader {
    private static final String VERSION_ATTRIBUTE = "content-version";
    private int requiredVersion;
    private Configuration configuration;

    public ConfigurationLoader(Configuration configuration, int requiredVersion) {
        this.configuration = configuration;
        this.requiredVersion = requiredVersion;
    }

    public void addFromStream(InputStream stream, boolean isSpecification) throws SAXException, IOException, ParserConfigurationException, IllegalConfigurationException {
        Document document = XmlUtil.parseReader(new InputStreamReader(stream));
        this.addFromXml(document, isSpecification);
    }

    public void addFromXml(Document xml, boolean isSpecification) throws IllegalConfigurationException {
        if (this.requiredVersion > 0) {
            int version;
            String contentVersion = "";
            if (xml.getDocumentElement().hasAttribute(VERSION_ATTRIBUTE)) {
                contentVersion = xml.getDocumentElement().getAttribute(VERSION_ATTRIBUTE);
            }
            if (contentVersion.equals("")) {
                throw new IllegalConfigurationException("version not specified");
            }
            try {
                version = Integer.parseInt(contentVersion);
            }
            catch (NumberFormatException e) {
                version = -1;
            }
            if (version < this.requiredVersion) {
                throw new IllegalConfigurationException("too old version (" + version + " when required is " + this.requiredVersion + ")");
            }
        }
        this.addFromNode(this.configuration.getRootModule(), xml.getDocumentElement(), isSpecification);
    }

    private void addFromNode(ConfigurationModule module, Element element, boolean isSpecification) throws IllegalConfigurationException {
        String name;
        NodeList entries = element.getChildNodes();
        for (int i = 0; i < entries.getLength(); ++i) {
            ConfigurationEntry configurationEntry;
            Node item = entries.item(i);
            if (!(item instanceof Element) || !"entry".equals(item.getNodeName())) continue;
            Element entry = (Element)item;
            name = entry.getAttribute("entryKey");
            String type = entry.getAttribute("type");
            NodeList values = entry.getElementsByTagName("value");
            if (name == null || type == null) {
                throw new IllegalConfigurationException("missing entryKey or type for " + name);
            }
            if (isSpecification) {
                configurationEntry = new ConfigurationEntry(name, type);
                module.addEntry(configurationEntry);
            } else {
                configurationEntry = module.getEntry(name);
                if (configurationEntry == null) {
                    throw new IllegalConfigurationException("unsupported entry: " + name);
                }
            }
            if (entry.hasAttribute("mustBeSet") && entry.getAttribute("mustBeSet").equals("true")) {
                if (values.getLength() > 0) {
                    throw new IllegalConfigurationException("illegal config specification: both values and mustBeSet given for " + name);
                }
                configurationEntry.setMustBeSet(true);
                continue;
            }
            String[] textValues = new String[values.getLength()];
            for (int v = 0; v < values.getLength(); ++v) {
                textValues[v] = values.item(v).getTextContent();
            }
            configurationEntry.setValue(textValues);
        }
        NodeList modules = element.getElementsByTagName("configuration-module");
        for (int i = 0; i < modules.getLength(); ++i) {
            Element submoduleElement = (Element)modules.item(i);
            name = submoduleElement.getAttribute("moduleId");
            if (!this.configuration.isModuleEnabled(name)) {
                if (isSpecification) continue;
                throw new IllegalConfigurationException("unsupported module: " + name);
            }
            if (!module.hasSubModule(name)) {
                module.createSubModule(name);
            }
            this.addFromNode(module.getModule(name), submoduleElement, isSpecification);
        }
    }

    public static class IllegalConfigurationException
    extends Exception {
        public IllegalConfigurationException(String string) {
            super(string);
        }
    }
}

