/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.soap.FileList;
import org.emboss.jemboss.soap.FileRoots;
import org.emboss.jemboss.soap.JembossSoapException;

public class RemoteFileNode
extends DefaultMutableTreeNode
implements Transferable,
Serializable {
    private boolean explored = false;
    private boolean isDir = false;
    private String fullname;
    private String serverPathToFile;
    private String rootdir;
    private transient FileList parentList;
    private transient JembossParams mysettings;
    private transient FileRoots froots;
    private String fs = "/";
    public static final DataFlavor REMOTEFILENODE = new DataFlavor(class$org$emboss$jemboss$gui$filetree$RemoteFileNode == null ? (class$org$emboss$jemboss$gui$filetree$RemoteFileNode = RemoteFileNode.class$("org.emboss.jemboss.gui.filetree.RemoteFileNode")) : class$org$emboss$jemboss$gui$filetree$RemoteFileNode, "Remote file");
    static DataFlavor[] remoteFlavors = new DataFlavor[]{REMOTEFILENODE, DataFlavor.stringFlavor};
    static /* synthetic */ Class class$org$emboss$jemboss$gui$filetree$RemoteFileNode;

    public RemoteFileNode(JembossParams jembossParams, FileRoots fileRoots, String string, FileList fileList, String string2) {
        this(jembossParams, fileRoots, string, fileList, string2, false);
    }

    public RemoteFileNode(JembossParams jembossParams, FileRoots fileRoots, String string, FileList fileList, String string2, boolean bl) {
        this.mysettings = jembossParams;
        this.froots = fileRoots;
        this.parentList = fileList;
        this.isDir = bl;
        this.rootdir = fileRoots.getCurrentRoot();
        this.serverPathToFile = (String)fileRoots.getRoots().get(this.rootdir);
        if (string.equals(" ")) {
            this.isDir = true;
        }
        if (string2 != null) {
            if (string2.endsWith("/.")) {
                string2 = string2.substring(0, string2.length() - 1);
            } else if (string2.endsWith(this.fs)) {
                string2 = string2.substring(0, string2.length());
            }
            if (string2.equals(".")) {
                this.fullname = string;
            } else {
                this.fullname = string2 + this.fs + string;
                this.serverPathToFile = this.serverPathToFile.endsWith(this.fs) ? this.serverPathToFile.concat(string2) : this.serverPathToFile.concat(this.fs + string2);
            }
        }
        if (fileList != null) {
            if (fileList.isDirectory(string)) {
                this.isDir = true;
            }
        } else if (string2 == null) {
            this.fullname = ".";
        }
        this.setUserObject(string);
    }

    public boolean getAllowsChildren() {
        return this.isDir;
    }

    public boolean isLeaf() {
        return !this.isDir;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public String getFile() {
        return (String)this.getUserObject();
    }

    public String getRootDir() {
        return this.rootdir;
    }

    public String getFullName() {
        return this.fullname;
    }

    public String getPathName() {
        return this.serverPathToFile;
    }

    public boolean isExplored() {
        return this.explored;
    }

    public String getServerName() {
        String string = this.serverPathToFile;
        if (!string.endsWith(this.fs)) {
            string = string.concat(this.fs);
        }
        if (this.fullname.equals(".")) {
            return string;
        }
        return string + (String)this.getUserObject();
    }

    public void explore() {
        if (!this.isDir) {
            return;
        }
        if (!this.explored) {
            try {
                FileList fileList = new FileList(this.mysettings, this.getRootDir(), this.fullname);
                Vector vector = fileList.fileVector();
                for (int i = 0; i < vector.size(); ++i) {
                    this.add(new RemoteFileNode(this.mysettings, this.froots, (String)vector.get(i), fileList, this.fullname));
                }
            }
            catch (JembossSoapException jembossSoapException) {
                jembossSoapException.printStackTrace();
            }
        }
        this.explored = true;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return remoteFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(REMOTEFILENODE) || dataFlavor.equals(DataFlavor.stringFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(REMOTEFILENODE)) {
            return this;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this.getServerName();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

