/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.emboss.jemboss.JembossJarUtil;

public class Matrix {
    private int[][] matrix;
    private int idimension;
    private int jdimension;
    private int i = 0;
    private int k = 0;
    private Hashtable residueMatrixPosition;
    private Object[] keys = null;
    private String cons = "";
    private String matrixString = null;
    private String matrixFileName = null;

    public Matrix(File file) {
        this.matrixFileName = file.getName();
        this.matrixRead(file);
    }

    public Matrix(String string, String string2) {
        this.matrixFileName = string2;
        try {
            Hashtable hashtable = new JembossJarUtil(string).getHash();
            this.keys = hashtable.keySet().toArray();
            Arrays.sort(this.keys);
            if (hashtable.containsKey(string2)) {
                this.matrixString = new String((byte[])hashtable.get(string2));
                this.matrixReadString(this.matrixString);
            } else {
                System.err.println("Matrix file " + string2 + " not found in jar file " + string);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Failed to read " + string2 + "\nfrom the matrix archive " + string, "Missing matrix archive", 0);
        }
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public String getMatrixTable() {
        return this.matrixString;
    }

    public String getCurrentMatrixName() {
        int n = this.matrixFileName.lastIndexOf("/");
        if (n > -1) {
            return this.matrixFileName.substring(n + 1);
        }
        return this.matrixFileName;
    }

    public Object[] getKeys() {
        return this.keys;
    }

    public Object[] getKeyNames() {
        try {
            int n = this.keys.length;
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)this.keys[i];
                if (string.indexOf("MANIFEST.MF") != -1) continue;
                int n2 = string.indexOf("/") + 1;
                objectArray[i] = string.substring(n2);
            }
            return objectArray;
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(null, "No matrix files found!", "Matrix files missing", 0);
            return null;
        }
    }

    public String getKeyNamesString() {
        try {
            int n = this.keys.length;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.keys[i];
                if (string.indexOf("MANIFEST.MF") != -1) continue;
                int n2 = string.indexOf("/") + 1;
                stringBuffer.append(string.substring(n2) + "\n");
            }
            return stringBuffer.toString();
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(null, "No matrix files found!", "Matrix files missing", 0);
            return null;
        }
    }

    public Hashtable getResidueMatrixPosition() {
        return this.residueMatrixPosition;
    }

    public int getMatrixIndex(String string) {
        if (!this.residueMatrixPosition.containsKey(string = string.toUpperCase()) && (string.equals(".") || string.equals("-") || string.equals("~"))) {
            string = "X";
        }
        if (!this.residueMatrixPosition.containsKey(string)) {
            return -1;
        }
        return (Integer)this.residueMatrixPosition.get(string);
    }

    public int getIDimension() {
        return this.idimension;
    }

    public int getJDimension() {
        return this.jdimension;
    }

    private RE getRegularExpression() {
        RE rE = null;
        try {
            RECompiler rECompiler = new RECompiler();
            REProgram rEProgram = rECompiler.compile("[:digit:]");
            rE = new RE(rEProgram);
        }
        catch (RESyntaxException rESyntaxException) {
            System.out.println("RESyntaxException ");
        }
        return rE;
    }

    private void matrixLineCount(String string, RE rE) {
        String string2 = " :\t\n";
        if (!string.startsWith("#") && !string.equals("") && rE.match(string)) {
            this.jdimension = 0;
            ++this.idimension;
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++this.jdimension;
            }
        }
    }

    private void matrixLineParse(String string, RE rE) {
        String string2 = " :\t\n";
        int n = 0;
        if (!string.startsWith("#") && !string.equals("")) {
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            if (!rE.match(string)) {
                while (stringTokenizer.hasMoreTokens()) {
                    this.residueMatrixPosition.put(stringTokenizer.nextToken(), new Integer(this.k));
                    ++this.k;
                }
            } else {
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    this.matrix[this.i][n] = Integer.parseInt(string3);
                    ++n;
                }
                ++this.i;
            }
        }
    }

    private int[][] matrixRead(File file) {
        BufferedReader bufferedReader;
        String string = " :\t\n";
        String string2 = "";
        this.residueMatrixPosition = new Hashtable();
        this.idimension = 1;
        RE rE = this.getRegularExpression();
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.matrixLineCount(string2, rE);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read matrix file in!");
        }
        this.matrix = new int[this.idimension][this.jdimension];
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.matrixLineParse(string2, rE);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read matrix file in!");
        }
        return this.matrix;
    }

    private int[][] matrixReadString(String string) {
        BufferedReader bufferedReader;
        String string2 = " :\t\n";
        String string3 = "";
        this.residueMatrixPosition = new Hashtable();
        this.idimension = 1;
        RE rE = this.getRegularExpression();
        try {
            bufferedReader = new BufferedReader(new StringReader(string));
            while ((string3 = bufferedReader.readLine()) != null) {
                this.matrixLineCount(string3, rE);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read matrix file in!");
        }
        this.matrix = new int[this.idimension][this.jdimension];
        try {
            bufferedReader = new BufferedReader(new StringReader(string));
            while ((string3 = bufferedReader.readLine()) != null) {
                this.matrixLineParse(string3, rE);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read matrix file in!");
        }
        return this.matrix;
    }
}

