/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class Block
extends JPanel
implements Transferable {
    private DNADraw current_dna;
    private Vector marker;
    private double angStart;
    private double angEnd;
    private double fracRadii = 1.0;
    private Rectangle rect = new Rectangle();
    public static final DataFlavor BLOCK = new DataFlavor(class$org$emboss$jemboss$draw$Block == null ? (class$org$emboss$jemboss$draw$Block = Block.class$("org.emboss.jemboss.draw.Block")) : class$org$emboss$jemboss$draw$Block, "Block");
    static DataFlavor[] blockFlavors = new DataFlavor[]{BLOCK};
    static /* synthetic */ Class class$org$emboss$jemboss$draw$Block;

    public Block(Vector vector) {
        this.setOpaque(false);
        this.marker = vector;
    }

    public Block(Vector vector, DNADraw dNADraw) {
        this(vector);
        this.current_dna = dNADraw;
        this.setPreferredSize(dNADraw.getPreferredSize());
    }

    public Vector getMarker() {
        return this.marker;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.draw(graphics2D);
    }

    protected void draw(Graphics2D graphics2D) {
        if (this.current_dna.isCircular()) {
            this.drawCircular(graphics2D);
        } else {
            this.drawLinear(graphics2D);
        }
    }

    protected String getLabel() {
        return (String)this.marker.elementAt(0);
    }

    protected int getStart() {
        return (Integer)this.marker.elementAt(1);
    }

    protected int getEnd() {
        return (Integer)this.marker.elementAt(2);
    }

    protected void showProperties(final JFrame jFrame, final DNADraw dNADraw, JButton jButton) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
            }
        });
        jMenu.add(jMenuItem);
        jFrame.setJMenuBar(jMenuBar);
        JPanel jPanel = (JPanel)jFrame.getContentPane();
        String string = (String)this.marker.elementAt(0);
        int n = (Integer)this.marker.elementAt(1);
        int n2 = (Integer)this.marker.elementAt(2);
        Color color = (Color)this.marker.elementAt(3);
        float f = ((Float)this.marker.elementAt(4)).floatValue();
        boolean bl = (Boolean)this.marker.elementAt(5);
        boolean bl2 = (Boolean)this.marker.elementAt(6);
        Box box = Box.createVerticalBox();
        jPanel.add(box);
        box.add(Box.createVerticalStrut(4));
        Dimension dimension = new Dimension(200, 30);
        Box box2 = Box.createHorizontalBox();
        final JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(dimension);
        jTextField.setMaximumSize(dimension);
        jTextField.setText(string);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Block.this.marker.setElementAt(jTextField.getText(), 0);
                if (dNADraw != null) {
                    dNADraw.repaint();
                }
            }
        });
        box2.add(jTextField);
        box2.add(new JLabel(" Label"));
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        dimension = new Dimension(65, 30);
        box2 = Box.createHorizontalBox();
        final TextFieldInt textFieldInt = new TextFieldInt();
        textFieldInt.setPreferredSize(dimension);
        textFieldInt.setMaximumSize(dimension);
        textFieldInt.setValue(n);
        textFieldInt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Block.this.marker.setElementAt(new Integer(textFieldInt.getValue()), 1);
                if (dNADraw != null) {
                    dNADraw.repaint();
                }
            }
        });
        box2.add(textFieldInt);
        box2.add(new JLabel(" Start"));
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        final TextFieldInt textFieldInt2 = new TextFieldInt();
        textFieldInt2.setPreferredSize(dimension);
        textFieldInt2.setMaximumSize(dimension);
        textFieldInt2.setValue(n2);
        textFieldInt2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Block.this.marker.setElementAt(new Integer(textFieldInt2.getValue()), 2);
                if (dNADraw != null) {
                    dNADraw.repaint();
                }
            }
        });
        box2.add(textFieldInt2);
        box2.add(new JLabel(" End"));
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        final JButton jButton2 = new JButton("");
        jButton2.setBackground(color);
        final JColorChooser jColorChooser = new JColorChooser();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Block.this.marker.setElementAt(jColorChooser.getColor(), 3);
                jButton2.setBackground(jColorChooser.getColor());
                if (dNADraw != null) {
                    dNADraw.repaint();
                }
            }
        };
        final JDialog jDialog = JColorChooser.createDialog(jButton2, "Pick a Color", true, jColorChooser, actionListener, null);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.show();
            }
        });
        box2 = Box.createHorizontalBox();
        box2.add(jButton2);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        final JSlider jSlider = new JSlider(1, 25, (int)f);
        box2.add(jSlider);
        box2.add(new JLabel(" Line width"));
        box2.add(Box.createHorizontalGlue());
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Block.this.marker.setElementAt(new Float(jSlider.getValue()), 4);
                if (dNADraw != null) {
                    dNADraw.repaint();
                }
            }
        });
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel("Arrow :"));
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        final JRadioButton jRadioButton = new JRadioButton("Head");
        final JRadioButton jRadioButton2 = new JRadioButton("Tail");
        final JRadioButton jRadioButton3 = new JRadioButton("None");
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButton.isSelected()) {
                    Block.this.marker.setElementAt(new Boolean(true), 5);
                    Block.this.marker.setElementAt(new Boolean(false), 6);
                } else {
                    Block.this.marker.setElementAt(new Boolean(false), 5);
                    Block.this.marker.setElementAt(new Boolean(true), 6);
                }
                if (dNADraw != null) {
                    dNADraw.repaint();
                }
            }
        });
        box2.add(jRadioButton);
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButton2.isSelected()) {
                    Block.this.marker.setElementAt(new Boolean(true), 6);
                    Block.this.marker.setElementAt(new Boolean(false), 5);
                } else {
                    Block.this.marker.setElementAt(new Boolean(false), 6);
                    Block.this.marker.setElementAt(new Boolean(true), 5);
                }
                if (dNADraw != null) {
                    dNADraw.repaint();
                }
            }
        });
        box2.add(jRadioButton2);
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButton3.isSelected()) {
                    Block.this.marker.setElementAt(new Boolean(false), 6);
                    Block.this.marker.setElementAt(new Boolean(false), 5);
                }
                if (dNADraw != null) {
                    dNADraw.repaint();
                }
            }
        });
        box2.add(jRadioButton3);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add(jButton);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        if (bl) {
            jRadioButton.setSelected(true);
        } else if (bl2) {
            jRadioButton2.setSelected(true);
        }
        jFrame.pack();
        jFrame.setVisible(true);
    }

    protected void drawLinear(Graphics2D graphics2D) {
        int[] nArray;
        String string = (String)this.marker.elementAt(0);
        int n = (Integer)this.marker.elementAt(1);
        int n2 = (Integer)this.marker.elementAt(2);
        Color color = (Color)this.marker.elementAt(3);
        float f = ((Float)this.marker.elementAt(4)).floatValue();
        float f2 = f / 2.0f;
        boolean bl = (Boolean)this.marker.elementAt(5);
        boolean bl2 = (Boolean)this.marker.elementAt(6);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = fontMetrics.getAscent();
        graphics2D.setColor(color);
        double d2 = this.current_dna.getDiameter();
        double d3 = this.current_dna.getWidth();
        double d4 = this.current_dna.getHeight();
        Point point = this.current_dna.getLocationPoint();
        int n3 = (int)(d4 / 2.0);
        int n4 = (int)this.fracRadii;
        if (n4 > 1 && n4 < (int)d4) {
            n3 = n4;
        }
        int n5 = this.current_dna.getStart();
        int n6 = this.current_dna.getEnd();
        graphics2D.setStroke(new BasicStroke(f));
        int n7 = ((int)d2 - point.x) * (n2 - n5) / (n6 - n5) + point.x - (int)f2;
        int n8 = ((int)d2 - point.x) * (n - n5) / (n6 - n5) + point.x + (int)f2;
        if (bl) {
            n7 = (int)((float)n7 - f2);
            nArray = new int[]{n7, n7, n7 + (int)f};
            int[] nArray2 = new int[]{n3 + (int)f, n3 - (int)f, n3};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.drawLine(n8, n3, n7, n3);
        } else if (bl2) {
            n8 = (int)((float)n8 + f2);
            nArray = new int[]{n8, n8, n8 - (int)f};
            int[] nArray3 = new int[]{n3 + (int)f, n3 - (int)f, n3};
            graphics2D.fillPolygon(nArray, nArray3, 3);
            graphics2D.drawLine(n8, n3, n7, n3);
        } else {
            graphics2D.drawLine(n8, n3, n7, n3);
        }
        this.rect.setLocation(n8, n3 - (int)f2);
        this.rect.setSize(n7 - n8, (int)f);
        int n9 = n8 + (int)((double)(n7 - n8) / 2.0 - (double)fontMetrics.stringWidth(string) / 2.0);
        graphics2D.drawString(string, (float)n9, (float)n3 - f);
    }

    protected void drawCircular(Graphics2D graphics2D) {
        int[] nArray;
        int n;
        int n2;
        String string = (String)this.marker.elementAt(0);
        int n3 = (Integer)this.marker.elementAt(1);
        int n4 = (Integer)this.marker.elementAt(2);
        Color color = (Color)this.marker.elementAt(3);
        float f = ((Float)this.marker.elementAt(4)).floatValue();
        boolean bl = (Boolean)this.marker.elementAt(5);
        boolean bl2 = (Boolean)this.marker.elementAt(6);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = fontMetrics.getAscent();
        graphics2D.setColor(color);
        double d2 = this.current_dna.getDiameter();
        double d3 = this.current_dna.getWidth();
        double d4 = this.current_dna.getHeight();
        double d5 = d2 / 2.0;
        double d6 = 360.0;
        Point point = this.current_dna.getLocationPoint();
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
        double d7 = Math.toDegrees(Math.asin((double)f / d5));
        double d8 = d7 / 2.0;
        this.angStart = this.current_dna.getAngleFromPosition(n3, d6) - d8;
        this.angEnd = this.current_dna.getAngleFromPosition(n4, d6) + d8 - this.angStart;
        int n5 = (int)(d5 * (1.0 - this.fracRadii));
        double d9 = d2 * this.fracRadii;
        if (bl) {
            this.angEnd += d8;
            affineTransform2.rotate(Math.toRadians(-this.angStart - this.angEnd), d3 / 2.0, d4 / 2.0);
            this.angEnd += d8 / 3.0;
            n2 = point.x + (int)(d2 - (double)n5);
            n = point.y + (int)d5;
            nArray = new int[]{n2 - (int)f, n2 + (int)f, n2};
            int[] nArray2 = new int[]{n, n, n + (int)f};
            graphics2D.setTransform(affineTransform2);
            graphics2D.fillPolygon(nArray, nArray2, 3);
        } else if (bl2) {
            this.angStart += d8;
            affineTransform2.rotate(Math.toRadians(-this.angStart), d3 / 2.0, d4 / 2.0);
            this.angStart -= d7;
            this.angEnd += d8;
            n2 = point.x + (int)(d2 - (double)n5);
            n = point.y + (int)d5;
            nArray = new int[]{n2 - (int)f, n2 + (int)f, n2};
            int[] nArray3 = new int[]{n + (int)f, n + (int)f, n};
            graphics2D.setTransform(affineTransform2);
            graphics2D.fillPolygon(nArray, nArray3, 3);
        }
        graphics2D.setStroke(new BasicStroke(f));
        graphics2D.setTransform(affineTransform);
        graphics2D.drawArc(point.x + n5, point.y + n5, (int)d9, (int)d9, Math.round(Math.round(this.angStart)), Math.round(Math.round(this.angEnd)));
        affineTransform2 = (AffineTransform)affineTransform.clone();
        affineTransform2.rotate(Math.toRadians(-this.angStart - this.angEnd / 2.0), d3 / 2.0, d4 / 2.0);
        n2 = 0;
        n = 0;
        int n6 = fontMetrics.stringWidth(string) / 2;
        n2 = (int)(d5 - (double)n5 / 2.0 + affineTransform2.getScaleX() * (d5 - 3.0 - (double)n6 - (double)((float)n5 + f) / 2.0) - (double)n6);
        n2 = (int)(d5 + affineTransform2.getScaleX() * (d5 - (double)n5 - 3.0 - (double)n6 - (double)f / 2.0) - (double)n6);
        n = (int)(d5 + affineTransform2.getShearY() * (d5 - (double)n5 - 3.0 - ((double)f + d) / 2.0) + d / 2.0);
        graphics2D.drawString(string, point.x + n2, point.y + n);
    }

    public void setBlockLocation(int n, int n2) {
        if (this.current_dna.isCircular()) {
            double d = this.current_dna.getDiameter() / 2.0;
            Point point = this.current_dna.getLocationPoint();
            double d2 = (double)point.x + d;
            double d3 = (double)point.y + d;
            double d4 = Math.sqrt(Math.pow(d3 - (double)n2, 2.0) + Math.pow(d2 - (double)n, 2.0));
            this.fracRadii = d4 / d;
        } else {
            this.fracRadii = n2;
        }
        this.repaint();
    }

    public boolean isOverMe(int n, int n2) {
        if (this.current_dna.isCircular()) {
            double d;
            double d2;
            double d3 = this.current_dna.getDiameter() / 2.0;
            Point point = this.current_dna.getLocationPoint();
            double d4 = (double)point.x + d3;
            double d5 = (double)point.y + d3;
            double d6 = (d5 - (double)n2) / (d4 - (double)n);
            double d7 = 180.0 - Math.toDegrees(Math.atan(d6));
            if ((double)n > d4) {
                d7 += 180.0;
            }
            if (d7 > 360.0) {
                d7 -= 360.0;
            }
            return d7 < 360.0 + this.angStart && d7 > 360.0 + this.angStart + this.angEnd && (d2 = (d = Math.sqrt(Math.pow(d5 - (double)n2, 2.0) + Math.pow(d4 - (double)n, 2.0))) / d3 / this.fracRadii) < 1.1 && d2 > 0.9;
        }
        return this.rect.contains(n, n2);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return blockFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(BLOCK);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(BLOCK)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

