/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.InvalidPatternException;
import it.sauronsoftware.cron4j.SchedulingPattern;
import it.sauronsoftware.cron4j.Task;
import it.sauronsoftware.cron4j.WatchedThread;
import java.util.ArrayList;

public class Scheduler {
    private static int counter = 0;
    private boolean started = false;
    private ArrayList tasks = new ArrayList();
    private Thread thread = null;
    private ArrayList watchedThreads = null;
    private Scheduler scheduler = this;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object schedule(String schedulingPattern, Runnable task) throws InvalidPatternException {
        SchedulingPattern myPattern = new SchedulingPattern(schedulingPattern);
        Task myTask = new Task(myPattern, task);
        ArrayList arrayList = this.tasks;
        synchronized (arrayList) {
            this.tasks.add(myTask);
        }
        return myTask.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reschedule(Object id, String schedulingPattern) throws InvalidPatternException {
        SchedulingPattern myPattern = new SchedulingPattern(schedulingPattern);
        ArrayList arrayList = this.tasks;
        synchronized (arrayList) {
            Task myTask = this.getTask(id);
            if (myTask != null) {
                myTask.setSchedulingPattern(myPattern);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deschedule(Object id) {
        ArrayList arrayList = this.tasks;
        synchronized (arrayList) {
            Task myTask = this.getTask(id);
            if (myTask != null) {
                this.tasks.remove(myTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Runnable getTaskRunnable(Object id) {
        ArrayList arrayList = this.tasks;
        synchronized (arrayList) {
            Task myTask = this.getTask(id);
            if (myTask != null) {
                return myTask.getRunnable();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getTaskSchedulingPattern(Object id) {
        ArrayList arrayList = this.tasks;
        synchronized (arrayList) {
            Task myTask = this.getTask(id);
            if (myTask != null) {
                return myTask.getSchedulingPattern().getOriginalString();
            }
        }
        return null;
    }

    public synchronized void start() throws IllegalStateException {
        if (this.started) {
            throw new IllegalStateException("Scheduler already started");
        }
        this.watchedThreads = new ArrayList();
        this.thread = new Thread((Runnable)new Runner(), "cron4j-scheduler-" + ++counter);
        this.thread.start();
        this.started = true;
    }

    public synchronized void stop() throws IllegalStateException {
        if (this.started) {
            this.started = false;
            this.thread.interrupt();
            boolean dead = false;
            do {
                try {
                    this.thread.join();
                    dead = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!dead);
        } else {
            throw new IllegalStateException("Scheduler not started");
        }
        this.thread = null;
        this.watchedThreads = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyWatchedThreadExiting(WatchedThread watchedThread) {
        ArrayList arrayList = this.watchedThreads;
        synchronized (arrayList) {
            this.watchedThreads.remove(watchedThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task getTask(Object id) {
        ArrayList arrayList = this.tasks;
        synchronized (arrayList) {
            int size = this.tasks.size();
            int i = 0;
            while (i < size) {
                Task myTask = (Task)this.tasks.get(i);
                if (myTask.getId().equals(id)) {
                    return myTask;
                }
                ++i;
            }
        }
        return null;
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long sleepTime;
            long nextMinute22;
            long millis;
            try {
                millis = System.currentTimeMillis();
                nextMinute22 = (millis / 60000L + 1L) * 60000L;
                sleepTime = nextMinute22 - millis;
                this.sleep(sleepTime);
            }
            catch (InterruptedException e1) {
                return;
            }
            while (true) {
                millis = System.currentTimeMillis();
                Object nextMinute22 = Scheduler.this.scheduler;
                synchronized (nextMinute22) {
                    if (!Scheduler.this.started) {
                        break;
                    }
                }
                nextMinute22 = Scheduler.this.tasks;
                synchronized (nextMinute22) {
                    int size = Scheduler.this.tasks.size();
                    int i = 0;
                    while (i < size) {
                        Task task = (Task)Scheduler.this.tasks.get(i);
                        SchedulingPattern pattern = task.getSchedulingPattern();
                        if (pattern.match(millis)) {
                            WatchedThread t = new WatchedThread(Scheduler.this.scheduler, task);
                            ArrayList arrayList = Scheduler.this.watchedThreads;
                            synchronized (arrayList) {
                                Scheduler.this.watchedThreads.add(t);
                            }
                            t.start();
                        }
                        ++i;
                    }
                }
                nextMinute22 = (millis / 60000L + 1L) * 60000L;
                sleepTime = nextMinute22 - System.currentTimeMillis();
                if (sleepTime <= 0L) continue;
                try {
                    this.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            while (true) {
                WatchedThread t;
                ArrayList arrayList = Scheduler.this.watchedThreads;
                synchronized (arrayList) {
                    if (Scheduler.this.watchedThreads.size() == 0) {
                        break;
                    }
                    t = (WatchedThread)Scheduler.this.watchedThreads.remove(0);
                }
                t.interrupt();
                boolean dead = false;
                do {
                    try {
                        t.join();
                        dead = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!dead);
            }
        }

        private void sleep(long millis) throws InterruptedException {
            long before;
            long after;
            long done = 0L;
            do {
                before = System.currentTimeMillis();
                Thread.sleep(millis - done);
            } while ((done += (after = System.currentTimeMillis()) - before) < millis);
        }
    }
}

