/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.som;

import java.awt.Color;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.som.SOMDataItem;

public class SOMDataset
extends AbstractDataset
implements Cloneable,
Serializable {
    protected SOMDataItem[][] data;

    public SOMDataset(int columns, int rows) throws IllegalArgumentException {
        if (columns <= 0) {
            throw new IllegalArgumentException("Non-positive column count given to SOMDataset");
        }
        if (rows <= 0) {
            throw new IllegalArgumentException("Non-positive row count given to SOMDataset");
        }
        this.data = new SOMDataItem[rows][columns];
    }

    public SOMDataItem getValue(int x, int y) throws IndexOutOfBoundsException {
        return this.data[y][x];
    }

    public int getColumnCount() {
        return this.data[0].length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public void addValue(int x, int y, Color color, String[] description, double[] neuronWeights) throws IndexOutOfBoundsException {
        this.data[y][x] = new SOMDataItem(color, description, neuronWeights);
    }

    public void addValue(int x, int y, SOMDataItem item) throws IndexOutOfBoundsException {
        if (item == null) {
            throw new NullPointerException("item given to addValue was null.");
        }
        this.data[y][x] = item;
    }

    public List getNeighbors(int x, int y, int maxDistance, boolean includeCenter) throws IndexOutOfBoundsException, IllegalArgumentException {
        SOMDataItem center = this.getValue(x, y);
        return this.getNeighbors(center, maxDistance, includeCenter);
    }

    public List getNeighbors(SOMDataItem center, int maxDistance, boolean includeCenter) throws IllegalArgumentException, NullPointerException {
        if (center == null) {
            throw new NullPointerException("center given to getNeighbors() was null");
        }
        if (maxDistance < 0) {
            throw new IllegalArgumentException("maxDistance given to getNeighbors() was negative.");
        }
        Color centerColor = center.getColor();
        LinkedList<SOMDataItem> list = new LinkedList<SOMDataItem>();
        SOMDatasetIterator i = new SOMDatasetIterator(this);
        while (i.hasNext()) {
            double diff;
            SOMDataItem item = (SOMDataItem)i.next();
            if (!includeCenter && item == center || !((diff = this.colorDistance(item.getColor(), centerColor)) <= (double)maxDistance)) continue;
            list.add(item);
        }
        return list;
    }

    private double colorDistance(Color color1, Color color2) {
        int r1 = color1.getRed();
        int g1 = color1.getGreen();
        int b1 = color1.getBlue();
        int r2 = color2.getRed();
        int g2 = color2.getGreen();
        int b2 = color2.getBlue();
        return Math.sqrt((r1 - r2) * (r1 - r2) + (g1 - g2) * (g1 - g2) + (b1 - b2) * (b1 - b2));
    }

    public List getArea(SOMDataItem item1, SOMDataItem item2) throws IllegalArgumentException, NullPointerException {
        if (item1 == null || item2 == null) {
            throw new NullPointerException("item1 or item2 given to getArea() was null");
        }
        int[] xy1 = this.getCoordinates(item1);
        int[] xy2 = this.getCoordinates(item2);
        if (xy1 == null || xy2 == null) {
            throw new IllegalArgumentException();
        }
        int width = Math.abs(xy1[0] - xy2[0]) + 1;
        int height = Math.abs(xy1[1] - xy2[1]) + 1;
        int startX = Math.min(xy1[0], xy2[0]);
        int startY = Math.min(xy1[1], xy2[1]);
        LinkedList<SOMDataItem> list = new LinkedList<SOMDataItem>();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                list.add(this.data[startY + y][startX + x]);
            }
        }
        return list;
    }

    private int[] getCoordinates(SOMDataItem item) {
        int[] xy = new int[2];
        for (int y = 0; y < this.data.length; ++y) {
            for (int x = 0; x < this.data[0].length; ++x) {
                if (item != this.data[y][x]) continue;
                xy[0] = x;
                xy[1] = y;
                return xy;
            }
        }
        return null;
    }

    public void changeHueValues(int angle) throws IllegalArgumentException {
        if (Math.abs(angle) > 360) {
            throw new IllegalArgumentException("angle value given to changeHueValues() was not in [-360,360].");
        }
        SOMDatasetIterator i = new SOMDatasetIterator(this);
        while (i.hasNext()) {
            SOMDataItem item = (SOMDataItem)i.next();
            if (item == null) continue;
            Color c = item.getColor();
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            hsb[0] = (float)((double)hsb[0] + ((double)angle / 360.0 + 1.0));
            hsb[0] = (float)((double)hsb[0] % 1.0);
            item.setColor(Color.getHSBColor(hsb[0], hsb[1], hsb[2]));
        }
    }

    public Iterator iterator() {
        return new SOMDatasetIterator(this);
    }

    public void deselectAll() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            SOMDataItem item = (SOMDataItem)i.next();
            item.setSelected(false);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SOMDataset)) {
            return false;
        }
        SOMDataset that = (SOMDataset)obj;
        int cols = this.getColumnCount();
        int rows = this.getRowCount();
        if (that.getColumnCount() != cols || that.getRowCount() != rows) {
            return false;
        }
        Iterator i1 = this.iterator();
        Iterator i2 = that.iterator();
        while (i1.hasNext()) {
            SOMDataItem item1 = (SOMDataItem)i1.next();
            SOMDataItem item2 = (SOMDataItem)i2.next();
            if (item1 == null && item2 == null || item1 != null && item2 != null && item1.equals(item2)) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        SOMDataset clone = (SOMDataset)super.clone();
        clone.data = (SOMDataItem[][])this.data.clone();
        return clone;
    }

    private class SOMDatasetIterator
    implements Iterator {
        private SOMDataset dataset;
        private int x;
        private int y;

        public SOMDatasetIterator(SOMDataset dataset) {
            this.dataset = dataset;
            this.x = 0;
            this.y = 0;
        }

        public boolean hasNext() {
            return this.y != this.dataset.getRowCount() || this.x != 0;
        }

        public Object next() {
            SOMDataItem item = this.dataset.getValue(this.x++, this.y);
            this.x %= this.dataset.getColumnCount();
            if (this.x == 0) {
                ++this.y;
            }
            return item;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("SOMDataset iterators do not implement remove().");
        }
    }
}

