/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.sql.SQLException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;

public abstract class TopLinkAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionFactory sessionFactory;
    private SQLExceptionTranslator jdbcExceptionTranslator;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void afterPropertiesSet() {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
    }

    public DataAccessException convertTopLinkAccessException(TopLinkException ex) {
        Throwable internalEx;
        if (this.getJdbcExceptionTranslator() != null && ex instanceof DatabaseException && (internalEx = ex.getInternalException()) instanceof SQLException) {
            return this.getJdbcExceptionTranslator().translate("TopLink operation: " + ex.getMessage(), null, (SQLException)internalEx);
        }
        return SessionFactoryUtils.convertTopLinkAccessException(ex);
    }
}

