/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.module.chipster;

import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import java.util.List;

public class ChipsterSADLParser
extends SADLParser {
    public ChipsterSADLParser() {
        this(null);
    }

    public ChipsterSADLParser(String filename) {
        super(filename);
        this.addInputType(ChipsterInputTypes.AFFY);
        this.addInputType(ChipsterInputTypes.CDNA);
        this.addInputType(ChipsterInputTypes.GENE_EXPRS);
        this.addInputType(ChipsterInputTypes.GENELIST);
        this.addInputType(ChipsterInputTypes.PHENODATA);
        this.addInputType(ChipsterInputTypes.BAM);
        this.addInputType(ChipsterInputTypes.FASTA);
    }

    public static class Validator {
        public void validate(String filename, String sadl) throws SADLParser.ParseException {
            ChipsterSADLParser parser = new ChipsterSADLParser(filename);
            List<SADLDescription> descriptions = parser.parseMultiple(sadl);
            for (SADLDescription description : descriptions) {
                this.checkParsedContent(description);
            }
        }

        private void checkParsedContent(SADLDescription description) {
            for (SADLDescription.Parameter parameter : description.parameters()) {
                if (parameter.getType() == SADLSyntax.ParameterType.ENUM) {
                    if (parameter.getSelectionOptions() == null || parameter.getSelectionOptions().length == 0) {
                        throw new RuntimeException("enum parameter " + parameter.getName() + " has no options");
                    }
                    for (String defaultValue : parameter.getDefaultValues()) {
                        boolean found = false;
                        for (SADLDescription.Name value : parameter.getSelectionOptions()) {
                            if (!defaultValue.equals(value.getID())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        throw new RuntimeException("enum parameter " + parameter.getName() + " has undefined default value \"" + defaultValue + "\"");
                    }
                    continue;
                }
                if (parameter.getDefaultValues().length <= 1) continue;
                throw new RuntimeException("non-enum parameter " + parameter.getName() + " has multiple default values");
            }
        }
    }
}

