/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.gbrowser.index;

import fi.csc.microarray.client.visualisation.methods.gbrowser.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.QueueManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.gbrowser.index.GeneResult;
import java.util.HashMap;
import java.util.Map;

public class GeneIndexActions
implements AreaResultListener {
    private QueueManager queueManager;
    private TabixDataSource gtfDataSource;
    private LineDataSource geneDataSource;
    private Map<String, GeneLocationListener> listenerMap = new HashMap<String, GeneLocationListener>();

    public GeneIndexActions(QueueManager queueManager, TabixDataSource gtfDataSource, LineDataSource geneDataSource) {
        this.queueManager = queueManager;
        this.gtfDataSource = gtfDataSource;
        this.geneDataSource = geneDataSource;
        queueManager.addResultListener(gtfDataSource, this);
        queueManager.addResultListener(geneDataSource, this);
    }

    public void requestLocation(String gene, GeneLocationListener listener) {
        this.listenerMap.put(gene, listener);
        this.queueManager.addAreaRequest(this.geneDataSource, new GeneRequest(gene, null), false);
    }

    private void requestLocation(String gene, Chromosome chr) {
        this.queueManager.addAreaRequest(this.gtfDataSource, new GeneRequest(gene, chr), false);
    }

    public static boolean checkIfNumber(String name) {
        try {
            Integer.parseInt(name);
            return true;
        }
        catch (NumberFormatException e) {
            try {
                Long.parseLong(name);
                return true;
            }
            catch (NumberFormatException e1) {
                return false;
            }
        }
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        if (areaResult instanceof GeneResult) {
            GeneResult geneResult = (GeneResult)areaResult;
            if (geneResult.getGeneLocation() == null) {
                this.listenerMap.get(geneResult.getSearchString()).geneLocation(geneResult.getGeneLocation());
                this.listenerMap.remove(geneResult.getSearchString());
            } else if (geneResult.getGeneLocation().start.bp != null) {
                this.listenerMap.get(geneResult.getSearchString()).geneLocation(geneResult.getGeneLocation());
                this.listenerMap.remove(geneResult.getSearchString());
            } else {
                this.requestLocation(geneResult.getSearchString(), geneResult.getGeneLocation().start.chr);
            }
        }
    }

    public static interface GeneLocationListener {
        public void geneLocation(Region var1);
    }
}

