/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class SADLParserTest {
    @BeforeTest
    public void init() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        DirectoryLayout.initialiseSimpleLayout().getConfiguration();
    }

    @Test(groups={"unit"})
    public void testVVSADLCompatibility() throws MicroarrayException, IOException {
        String vvsadl = "ANALYSIS \"Test utilities\"/\"Test tool\" (Just a test analysis for development. These descriptions are sometimes very\nlong and might get hard to read.)\nINPUT CDNA microarray[...].txt OUTPUT results.txt, messages.txt\nPARAMETER value1 INTEGER FROM 0 TO 200 DEFAULT 10 (the first value of the result set)\nPARAMETER value2 DECIMAL FROM 0 TO 200 DEFAULT 20 (the second value of the result set)\nPARAMETER value3 DECIMAL FROM 0 TO 200 DEFAULT 30.2 (the third value of the result set)\nPARAMETER method PERCENT DEFAULT 34 (how much we need)\nPARAMETER method [linear, logarithmic, exponential] DEFAULT logarithmic (which scale to use)\nPARAMETER genename STRING DEFAULT at_something (which gene we are interested in)\nPARAMETER key COLUMN_SEL (which column we use as a key)";
        SADLDescription parsedDescription = new ChipsterSADLParser().parse(vvsadl);
        Assert.assertNotNull((Object)parsedDescription);
        Assert.assertEquals((String)parsedDescription.getName().getID(), (String)"Test tool");
        Assert.assertEquals((String)parsedDescription.getName().getDisplayName(), (String)"Test tool");
        Assert.assertTrue((boolean)parsedDescription.getComment().startsWith("Just a test analysis"));
        Assert.assertEquals((int)parsedDescription.inputs().size(), (int)1);
        Assert.assertTrue((boolean)parsedDescription.inputs().get(0).getName().isNameSet());
        Assert.assertEquals((int)parsedDescription.outputs().size(), (int)2);
        Assert.assertEquals((int)parsedDescription.parameters().size(), (int)7);
        Assert.assertEquals((int)parsedDescription.parameters().get(4).getSelectionOptions().length, (int)3);
    }

    @Test(groups={"unit"})
    public void testParsing() throws MicroarrayException, IOException {
        String sadl = "TOOL util-test.R: \"Test tool\" (Just a test analysis for development. These descriptions are sometimes very\nlong and might get hard to read. (Note that certain operators must be escaped.\\))\nINPUT microarray{...}.tsv: \"Raw data files\" TYPE CDNA\nINPUT phenodata.tsv: \"Experiment description\" TYPE GENERIC\nOUTPUT result{...}.txt: \"Result files\"\nOUTPUT OPTIONAL error.txt: \"Error, if any\" (Here's an example of a comment on an output file.)\nPARAMETER value1: \"The first value\" TYPE INTEGER FROM 0 TO 200 DEFAULT 10 (the first value of the result set)\nPARAMETER value2: \"The second value\" TYPE DECIMAL FROM 0 TO 200 DEFAULT 20 (the second value of the result set)\nPARAMETER OPTIONAL value3: \"The third value\" TYPE DECIMAL FROM 0 TO 200 DEFAULT 30.2 (the third value of the result set)\nPARAMETER value4: \"The fourth value\" TYPE PERCENT DEFAULT 34 (how much we need)\nPARAMETER method: \"The enumeration\" TYPE [option1: \"First option\", option2: \"Second option\", option3: \"Third option\"] FROM 1 TO 2 DEFAULT option1, option2 (which options are selected)\nPARAMETER genename: \"Gene name\" TYPE STRING DEFAULT at_something (which gene we are interested in)\nPARAMETER key: \"Key column\" TYPE COLUMN_SEL (which column we use as a key)";
        SADLDescription parsedDescription = new ChipsterSADLParser().parse(sadl);
        Assert.assertNotNull((Object)parsedDescription);
        Assert.assertEquals((String)parsedDescription.getName().getID(), (String)"util-test.R");
        Assert.assertEquals((String)parsedDescription.getName().getDisplayName(), (String)"Test tool");
        Assert.assertEquals((String)parsedDescription.getName().toString(), (String)"util-test.R: \"Test tool\"");
        Assert.assertTrue((boolean)parsedDescription.getComment().startsWith("Just a test analysis"));
        Assert.assertTrue((boolean)parsedDescription.getComment().endsWith("must be escaped.)"));
        Assert.assertEquals((int)parsedDescription.inputs().size(), (int)2);
        Assert.assertTrue((boolean)parsedDescription.inputs().get(0).getName().isNameSet());
        Assert.assertEquals((String)parsedDescription.inputs().get(0).getName().getPrefix(), (String)"microarray");
        Assert.assertEquals((String)parsedDescription.inputs().get(0).getName().getPostfix(), (String)".tsv");
        Assert.assertEquals((String)parsedDescription.inputs().get(0).getName().getDisplayName(), (String)"Raw data files");
        Assert.assertEquals((String)parsedDescription.inputs().get(0).getType().getName(), (String)"CDNA");
        Assert.assertFalse((boolean)parsedDescription.inputs().get(0).isOptional());
        Assert.assertEquals((String)parsedDescription.inputs().get(1).getName().toString(), (String)"phenodata.tsv: \"Experiment description\"");
        Assert.assertEquals((String)parsedDescription.inputs().get(1).getType().getName(), (String)"GENERIC");
        Assert.assertFalse((boolean)parsedDescription.inputs().get(1).isOptional());
        Assert.assertEquals((int)parsedDescription.outputs().size(), (int)2);
        Assert.assertTrue((boolean)parsedDescription.outputs().get(0).getName().isNameSet());
        Assert.assertEquals((String)parsedDescription.outputs().get(0).getName().getPrefix(), (String)"result");
        Assert.assertEquals((String)parsedDescription.outputs().get(0).getName().getPostfix(), (String)".txt");
        Assert.assertEquals((String)parsedDescription.outputs().get(0).getName().getDisplayName(), (String)"Result files");
        Assert.assertFalse((boolean)parsedDescription.outputs().get(0).isOptional());
        Assert.assertEquals((String)parsedDescription.outputs().get(1).getName().toString(), (String)"error.txt: \"Error, if any\"");
        Assert.assertEquals((String)parsedDescription.outputs().get(1).getComment(), (String)"Here's an example of a comment on an output file.");
        Assert.assertTrue((boolean)parsedDescription.outputs().get(1).isOptional());
        Assert.assertEquals((int)parsedDescription.parameters().size(), (int)7);
        Assert.assertEquals((String)parsedDescription.parameters().get(0).getName().toString(), (String)"value1: \"The first value\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(0).getType()), (Object)((Object)SADLSyntax.ParameterType.INTEGER));
        Assert.assertEquals((String)parsedDescription.parameters().get(0).getFrom(), (String)"0");
        Assert.assertEquals((String)parsedDescription.parameters().get(0).getTo(), (String)"200");
        Assert.assertEquals((String)parsedDescription.parameters().get(0).getDefaultValue(), (String)"10");
        Assert.assertEquals((String)parsedDescription.parameters().get(0).getComment(), (String)"the first value of the result set");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(0).isOptional());
        Assert.assertEquals((String)parsedDescription.parameters().get(1).getName().toString(), (String)"value2: \"The second value\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(1).getType()), (Object)((Object)SADLSyntax.ParameterType.DECIMAL));
        Assert.assertEquals((String)parsedDescription.parameters().get(1).getFrom(), (String)"0");
        Assert.assertEquals((String)parsedDescription.parameters().get(1).getTo(), (String)"200");
        Assert.assertEquals((String)parsedDescription.parameters().get(1).getDefaultValue(), (String)"20");
        Assert.assertEquals((String)parsedDescription.parameters().get(1).getComment(), (String)"the second value of the result set");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(1).isOptional());
        Assert.assertEquals((String)parsedDescription.parameters().get(2).getName().toString(), (String)"value3: \"The third value\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(2).getType()), (Object)((Object)SADLSyntax.ParameterType.DECIMAL));
        Assert.assertEquals((String)parsedDescription.parameters().get(2).getFrom(), (String)"0");
        Assert.assertEquals((String)parsedDescription.parameters().get(2).getTo(), (String)"200");
        Assert.assertEquals((String)parsedDescription.parameters().get(2).getDefaultValue(), (String)"30.2");
        Assert.assertEquals((String)parsedDescription.parameters().get(2).getComment(), (String)"the third value of the result set");
        Assert.assertTrue((boolean)parsedDescription.parameters().get(2).isOptional());
        Assert.assertEquals((String)parsedDescription.parameters().get(3).getName().toString(), (String)"value4: \"The fourth value\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(3).getType()), (Object)((Object)SADLSyntax.ParameterType.PERCENT));
        Assert.assertEquals((String)parsedDescription.parameters().get(3).getDefaultValue(), (String)"34");
        Assert.assertEquals((String)parsedDescription.parameters().get(3).getComment(), (String)"how much we need");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(3).isOptional());
        Assert.assertEquals((String)parsedDescription.parameters().get(4).getName().toString(), (String)"method: \"The enumeration\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(4).getType()), (Object)((Object)SADLSyntax.ParameterType.ENUM));
        Assert.assertEquals((int)parsedDescription.parameters().get(4).getDefaultValues().length, (int)2);
        Assert.assertEquals((String)parsedDescription.parameters().get(4).getDefaultValues()[0], (String)"option1");
        Assert.assertEquals((String)parsedDescription.parameters().get(4).getDefaultValues()[1], (String)"option2");
        Assert.assertEquals((String)parsedDescription.parameters().get(4).getComment(), (String)"which options are selected");
        Assert.assertEquals((String)parsedDescription.parameters().get(4).getFrom(), (String)"1");
        Assert.assertEquals((String)parsedDescription.parameters().get(4).getTo(), (String)"2");
        Assert.assertEquals((int)parsedDescription.parameters().get(4).getSelectionOptions().length, (int)3);
        Assert.assertEquals((String)parsedDescription.parameters().get(4).getSelectionOptions()[0].toString(), (String)"option1: \"First option\"");
        Assert.assertEquals((String)parsedDescription.parameters().get(4).getSelectionOptions()[1].toString(), (String)"option2: \"Second option\"");
        Assert.assertEquals((String)parsedDescription.parameters().get(4).getSelectionOptions()[2].toString(), (String)"option3: \"Third option\"");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(4).isOptional());
        Assert.assertEquals((String)parsedDescription.parameters().get(5).getName().toString(), (String)"genename: \"Gene name\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(5).getType()), (Object)((Object)SADLSyntax.ParameterType.STRING));
        Assert.assertEquals((String)parsedDescription.parameters().get(5).getDefaultValue(), (String)"at_something");
        Assert.assertEquals((String)parsedDescription.parameters().get(5).getComment(), (String)"which gene we are interested in");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(5).isOptional());
        Assert.assertEquals((String)parsedDescription.parameters().get(6).getName().toString(), (String)"key: \"Key column\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(6).getType()), (Object)((Object)SADLSyntax.ParameterType.COLUMN_SEL));
        Assert.assertEquals((String)parsedDescription.parameters().get(6).getComment(), (String)"which column we use as a key");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(6).isOptional());
    }

    @Test(groups={"unit"})
    public void testRoundtrip() throws MicroarrayException, IOException {
        SADLDescription description = this.generateDescription();
        String string = description.toString();
        SADLDescription parsedDescription = new ChipsterSADLParser().parse(string);
        String anotherString = parsedDescription.toString();
        Assert.assertEquals((String)string, (String)anotherString);
        Assert.assertEquals((String)parsedDescription.inputs().get(0).getName().getID(), (String)"input1");
        Assert.assertEquals((String)parsedDescription.inputs().get(0).getComment(), (String)"input comment");
        Assert.assertTrue((boolean)parsedDescription.inputs().get(0).isOptional());
        Assert.assertEquals((String)parsedDescription.inputs().get(1).getName().getPrefix(), (String)"input2");
        Assert.assertEquals((int)parsedDescription.inputs().size(), (int)4);
        Assert.assertEquals((int)parsedDescription.parameters().size(), (int)2);
        Assert.assertEquals((String)parsedDescription.parameters().get(1).getFrom(), (String)"1");
    }

    @Test(groups={"unit"})
    public void testEscapes() throws MicroarrayException, IOException {
        SADLDescription description = this.generateDescription();
        Assert.assertEquals((String)description.getComment(), (String)"main comment (funny)");
        String string = description.toString();
        Assert.assertTrue((boolean)string.contains("main comment (funny\\)"));
        SADLDescription parsedDescription = new ChipsterSADLParser().parse(string);
        Assert.assertEquals((String)parsedDescription.getComment(), (String)"main comment (funny)");
        String anotherString = parsedDescription.toString();
        Assert.assertTrue((boolean)anotherString.contains("main comment (funny\\)"));
    }

    private SADLDescription generateDescription() {
        SADLDescription description = new SADLDescription(SADLDescription.Name.createName("name", "longname/displayname"), "main comment (funny)");
        SADLDescription.Input input = new SADLDescription.Input(ChipsterInputTypes.GENE_EXPRS, SADLDescription.Name.createName("input1", "input1"), true);
        input.setComment("input comment");
        description.addInput(input);
        description.addInput(new SADLDescription.Input(ChipsterInputTypes.GENE_EXPRS, SADLDescription.Name.createNameSet("input2", ".ext", "input set 2")));
        description.addInput(new SADLDescription.Input(ChipsterInputTypes.GENE_EXPRS, SADLDescription.Name.createName("metainput1", "metainput1"), false, true));
        description.addInput(new SADLDescription.Input(ChipsterInputTypes.GENE_EXPRS, SADLDescription.Name.createNameSet("metainput2", ".ext", "meta input set 2"), false, true));
        description.addOutput(new SADLDescription.Output(SADLDescription.Name.createName("output1", "output1")));
        description.addOutput(new SADLDescription.Output(SADLDescription.Name.createName("metaoutput1", "metaoutput1"), false, true));
        description.addParameter(new SADLDescription.Parameter(SADLDescription.Name.createName("parameter1", "parameter1"), SADLSyntax.ParameterType.DECIMAL, null, "1", "3", "2", "param comment 1"));
        description.addParameter(new SADLDescription.Parameter(SADLDescription.Name.createName("parameter2", "parameter2"), SADLSyntax.ParameterType.ENUM, new SADLDescription.Name[]{SADLDescription.Name.createName("1"), SADLDescription.Name.createName("2"), SADLDescription.Name.createName("3")}, "1", "2", new String[]{"1", "2"}, "param comment 2"));
        return description;
    }

    public static void main(String[] args) throws MicroarrayException, IOException, ConfigurationLoader.IllegalConfigurationException {
        DirectoryLayout.initialiseSimpleLayout().getConfiguration();
        new SADLParserTest().testParsing();
        new SADLParserTest().testRoundtrip();
        new SADLParserTest().testEscapes();
        new SADLParserTest().testVVSADLCompatibility();
        System.out.println("SADLParserTest OK");
    }
}

