/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RepeatMaskerTrack
extends Track {
    private long minBpLength;
    private long maxBpLength;
    private Color color;
    private Collection<RegionContent> regions = new TreeSet<RegionContent>();

    public RepeatMaskerTrack(View view, TabixDataSource file, long minBpLength, long maxBpLength) {
        super(view, file);
        this.color = Color.lightGray;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.regions != null) {
            Iterator<RegionContent> iter = this.regions.iterator();
            RegionContent regionContent = null;
            while (iter.hasNext()) {
                regionContent = iter.next();
                if (!regionContent.region.intersects(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                BpCoord startBp = regionContent.region.start;
                BpCoord endBp = new BpCoord(regionContent.region.end.bp + 1L, regionContent.region.end.chr);
                long startX = this.getView().bpToTrack(startBp).intValue();
                long endX = this.getView().bpToTrack(endBp).intValue();
                drawables.add(new RectDrawable(new Rectangle((int)startX, 0, (int)(endX - startX), this.getHeight()), this.color, this.color));
            }
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        this.regions.addAll(areaResult.getContents());
        this.getView().redraw();
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    @Override
    public boolean isStretchable() {
        return false;
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return 5;
        }
        return 0;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(new ColumnType[0])));
        return datas;
    }

    @Override
    public String getName() {
        return "RepeatMaskerTrack";
    }
}

