/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GenomePlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class CircularView
extends View {
    private Point offset;
    private float angleOffset = (float)Math.PI;

    public CircularView(GenomePlot parent, boolean movable, boolean zoomable, boolean selectable) {
        super(parent, movable, zoomable, selectable);
    }

    @Override
    protected void drawView(Graphics2D g, boolean isAnimation, Rectangle viewPort) {
        super.drawView(g, isAnimation, viewPort);
        if (this.highlight != null) {
            g.setPaint(new Color(0, 0, 0, 64));
            Rectangle rect = g.getClip().getBounds();
            rect.x = this.bpToTrack(this.highlight.start);
            rect.width = this.bpToTrack(this.highlight.end) - rect.x;
            g.fill(rect);
        }
    }

    @Override
    protected void drawDrawable(Graphics2D g, int x, int y, Drawable drawable) {
        this.offset = new Point(x, y);
        g.setPaint(drawable.color);
        if (drawable instanceof TextDrawable) {
            TextDrawable text = (TextDrawable)drawable;
            int pixelLength = 0;
            for (int i = 0; i < text.text.length(); ++i) {
                char chr = text.text.charAt(i);
                Point2D.Float p = this.toCircle(new Point(text.x + pixelLength, text.y - 4));
                if (p != null) {
                    TextLayout tl = new TextLayout("" + text.text.charAt(i), g.getFont(), g.getFontRenderContext());
                    Shape rotatedChar = tl.getOutline(AffineTransform.getRotateInstance(this.getAngle(p), tl.getBounds().getCenterX(), tl.getBounds().getCenterY()));
                    g.translate((double)p.x - tl.getBounds().getCenterX(), (double)p.y - tl.getBounds().getCenterY());
                    g.fill(rotatedChar);
                    g.translate(-((double)p.x - tl.getBounds().getCenterX()), -((double)p.y - tl.getBounds().getCenterY()));
                }
                pixelLength += g.getFontMetrics().charWidth(chr);
            }
        } else if (drawable instanceof RectDrawable) {
            RectDrawable rect = (RectDrawable)drawable;
            this.drawPerimeterLine(g, rect);
            this.drawRectRadialOutline(g, rect);
            int height = rect.height;
            rect.height = 1;
            rect.color = rect.lineColor;
            this.drawPerimeterLine(g, rect);
            rect.y += height;
            this.drawPerimeterLine(g, rect);
        } else if (drawable instanceof LineDrawable) {
            LineDrawable line = (LineDrawable)drawable;
            Point2D.Float p1 = new Point2D.Float(line.x, line.y);
            Point2D.Float p2 = new Point2D.Float(line.x2, line.y2);
            this.drawAnyLine(g, p1.x, p1.y, p2.x, p2.y);
        }
    }

    private float asDeg(float radian) {
        return (float)((double)(radian * 360.0f) / (Math.PI * 2));
    }

    private void drawRectRadialOutline(Graphics2D g, RectDrawable rect) {
        g.setPaint(rect.lineColor);
        float x1 = rect.x;
        float x2 = rect.x + rect.width;
        float y1 = rect.y;
        float y2 = rect.y + rect.height;
        this.drawAnyLine(g, x1, y1, x1, y2);
        this.drawAnyLine(g, x2, y1, x2, y2);
    }

    private void drawPerimeterLine(Graphics2D g, RectDrawable rect) {
        rect.height = Math.max(rect.height, 0);
        g.setPaint(rect.color);
        g.setStroke(new BasicStroke(rect.height, 0, 2));
        Point2D.Float startPoint = this.toCircle(new Point2D.Float(rect.x, rect.y));
        Point2D.Float endPoint = this.toCircle(new Point2D.Float(rect.x + rect.width, rect.y));
        if (startPoint != null && endPoint != null) {
            float r = rect.y + this.offset.y + rect.height / 2;
            float startAngle = this.getAngle(startPoint);
            float start = this.asDeg(this.getAngle(startPoint));
            float extent = this.asDeg(this.getAngle(endPoint) - startAngle);
            start = -(start - 90.0f);
            extent = -extent;
            g.draw(new Arc2D.Float((float)this.getCenterX() - r, (float)this.getCenterY() - r, r * 2.0f, r * 2.0f, start, extent, 0));
        }
        g.setStroke(new BasicStroke(1.0f));
    }

    private void drawAnyLine(Graphics2D g, float x1, float y1, float x2, float y2) {
        int parts = (int)(Math.abs(x2 - x1) * Math.abs(this.getAngle(x2) - this.getAngle(x1)) + 1.0f);
        float dx = (x2 - x1) / (float)parts;
        float dy = (y2 - y1) / (float)parts;
        Point2D.Float p2 = null;
        for (int i = 0; i <= parts; ++i) {
            Point2D.Float p1 = this.toCircle(new Point2D.Float(x1, y1 + 0.5f));
            if (p2 != null && p1 != null) {
                g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
            }
            p2 = p1;
            x1 += dx;
            y1 += dy;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.zoomable) {
            double pointerBp = this.pointToBp((Point2D.Float)new Point2D.Float((float)((float)e.getPoint().x), (float)((float)e.getPoint().y))).bp;
            double pointerRelative = (pointerBp - this.bpRegion.start.bp) / this.bpRegion.getLength();
            if (e.getWheelRotation() > 0) {
                pointerRelative = 1.0 - pointerRelative;
            }
            pointerBp = this.bpRegion.start.bp + pointerRelative * this.bpRegion.getLength();
            double startBp = this.getBpRegionDouble().start.bp;
            double endBp = this.getBpRegionDouble().end.bp;
            double width = endBp - startBp;
            startBp = pointerBp - (width *= Math.pow(1.06f, e.getWheelRotation())) * pointerRelative;
            endBp = pointerBp + width * (1.0 - pointerRelative);
            if (startBp < 0.0) {
                endBp += -startBp;
                startBp = 0.0;
            }
            this.setBpRegion(new RegionDouble(startBp, endBp, new Chromosome("1")), false);
        }
    }

    @Override
    protected void handleDrag(Point2D start, Point2D end, boolean disableDrawing) {
        Point2D.Float startPoint = new Point2D.Float((float)start.getX(), (float)start.getY());
        Point2D.Float endPoint = new Point2D.Float((float)end.getX(), (float)end.getY());
        float a1 = this.getAngle(startPoint);
        float a2 = this.getAngle(endPoint);
        double bpMove = this.pointToBp(startPoint).minus(this.pointToBp(endPoint));
        if ((double)a1 > Math.PI && (double)a2 < 1.5707963267948966) {
            bpMove -= this.bpRegion.getLength();
        }
        if ((double)a2 > Math.PI && (double)a1 < 1.5707963267948966) {
            bpMove += this.bpRegion.getLength();
        }
        if (bpMove < 0.0 && this.bpRegion.start.bp < Math.abs(bpMove)) {
            bpMove = -this.bpRegion.start.bp.doubleValue();
        }
        this.bpRegion.move(bpMove);
        this.setBpRegion(this.bpRegion, disableDrawing);
        this.parentPlot.redraw();
    }

    private Point2D.Float toCircle(Point xy) {
        return this.toCircle(new Point2D.Float(xy.x, xy.y));
    }

    private Point2D.Float toCircle(Point2D.Float xy) {
        float r = xy.y + (float)this.offset.y;
        if (xy.x < (float)this.offset.x || xy.x > (float)(this.getWidth() + this.offset.x - this.margin)) {
            return null;
        }
        float angle = -this.getAngle(xy.x - (float)this.offset.x);
        float dx = (int)(Math.sin(angle) * (double)r);
        float dy = (int)(Math.cos(angle) * (double)r);
        return new Point2D.Float(dx + (float)this.getCenterX(), dy + (float)this.getCenterY());
    }

    private int getCenterX() {
        return this.getWidth() / 2 + this.offset.x;
    }

    private int getCenterY() {
        return this.getStaticHeight();
    }

    @Override
    public int getStaticHeight() {
        return super.getStaticHeight() / 2;
    }

    private float getAngle(Point2D.Float p) {
        float a = (float)(Math.atan((p.y - (float)this.getCenterY()) / (p.x - (float)this.getCenterX())) + 1.5707963267948966);
        if (p.x < (float)this.getCenterX()) {
            a = (float)((double)a + Math.PI);
        }
        return a;
    }

    private BpCoordDouble pointToBp(Point2D.Float p) {
        return this.trackToBp((double)(this.getAngle(p) * (float)this.getWidth() / 2.0f) / Math.PI + (double)this.offset.x);
    }

    private float getAngle(float x) {
        return x / (float)this.getWidth() * (float)Math.PI * 2.0f + this.angleOffset;
    }
}

