/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;

public class IntegerParameter
extends Parameter {
    private Integer minValue;
    private Integer maxValue;
    private Integer value;

    public IntegerParameter(String id, String displayName, String description, Integer minValue, Integer maxValue, Integer initValue) throws IllegalArgumentException {
        super(id, displayName, description);
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (initValue == null) {
            this.value = null;
            return;
        }
        if (maxValue < minValue) {
            throw new IllegalArgumentException("Minimum value for integer parameter " + this.getID() + " cannot be bigger than the maximum value.");
        }
        this.setIntegerValue(initValue);
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public Integer getIntegerValue() {
        return this.value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setMinValue(int newMinValue) {
        if (newMinValue > this.maxValue) {
            throw new IllegalArgumentException("New minimum value for " + this.getID() + " cannot exceed current maximum value.");
        }
        this.minValue = newMinValue;
        if (this.value < this.minValue) {
            this.value = this.minValue;
        }
    }

    public void setMaxValue(int newMaxValue) {
        if (newMaxValue < this.minValue) {
            throw new IllegalArgumentException("New maximum value for " + this.getID() + " cannot fall below current minimum value.");
        }
        this.maxValue = newMaxValue;
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        }
    }

    public void setIntegerValue(Integer newValue) throws IllegalArgumentException {
        if (newValue != null && (newValue < this.minValue || newValue > this.maxValue)) {
            throw new IllegalArgumentException("New value for integer parameter " + this.getID() + " must be inside given limits.");
        }
        this.value = newValue;
    }

    @Override
    public void setValue(Object newValue) throws IllegalArgumentException {
        if (!(newValue instanceof Integer) && newValue != null) {
            throw new IllegalArgumentException(newValue + " is an illegal " + "value for integer parameter " + this.getID() + ".");
        }
        this.setIntegerValue((Integer)newValue);
    }

    @Override
    public boolean checkValidityOf(Object valueObject) {
        if (valueObject == null) {
            return true;
        }
        if (!(valueObject instanceof Integer)) {
            return false;
        }
        Integer intValue = (Integer)valueObject;
        return intValue >= this.minValue && intValue <= this.maxValue;
    }

    @Override
    public String toString() {
        return this.getID() + ": " + this.value;
    }

    @Override
    public String getValueAsJava() {
        return "" + this.value;
    }

    @Override
    public void parseValue(String stringValue) throws IllegalArgumentException {
        if (stringValue == null || stringValue.equals("")) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(Integer.parseInt(stringValue));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("cannot parse String value \"" + stringValue + "\"");
        }
    }

    @Override
    public String getValueAsString() {
        return this.value != null ? this.value.toString() : "";
    }
}

