/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.EnumParameter;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.LinkedList;

public abstract class DataSelectionParameter
extends EnumParameter {
    protected String initValue;

    public DataSelectionParameter(String id, String displayName, String description, String initValue) {
        super(id, displayName, description);
        this.initValue = initValue;
    }

    protected void loadOptionsFromColumnNames(DataBean data) throws MicroarrayException {
        int initIndex = 0;
        LinkedList<String> colNames = new LinkedList<String>();
        if (data != null) {
            Table columns = data.queryFeatures("/column/*").asTable();
            for (String columnName : columns.getColumnNames()) {
                colNames.add(columnName);
            }
        }
        colNames.add("EMPTY");
        for (int i = 0; i < colNames.size(); ++i) {
            if (!((String)colNames.get(i)).equals(this.initValue)) continue;
            initIndex = i;
            break;
        }
        String[] strings = colNames.toArray(new String[colNames.size()]);
        EnumParameter.SelectionOption[] optionObjects = EnumParameter.SelectionOption.convertStrings(strings, strings);
        LinkedList<EnumParameter.SelectionOption> defaultOptions = new LinkedList<EnumParameter.SelectionOption>();
        defaultOptions.add(optionObjects[initIndex]);
        this.setOptions(optionObjects, defaultOptions);
    }

    public void parseValueAndSetWithoutChecks(String stringValue) {
        String[] stringValues = stringValue.split(",");
        LinkedList<EnumParameter.SelectionOption> selectedOptions = new LinkedList<EnumParameter.SelectionOption>();
        for (String optionValue : stringValues) {
            selectedOptions.add(new EnumParameter.SelectionOption(optionValue, optionValue));
        }
        super.setSelectedOptions(selectedOptions);
    }
}

