/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.SwingClientApplication;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SessionRestoreDialog
extends JDialog
implements ActionListener {
    private final Dimension BUTTON_SIZE = new Dimension(75, 25);
    private JButton restoreButton;
    private JButton discardButton;
    private ClientApplication client;
    private File sessionFile;

    public SessionRestoreDialog(SwingClientApplication client, File sessionFile) {
        super((Frame)null, "Restore session");
        this.client = client;
        this.sessionFile = sessionFile;
        this.restoreButton = new JButton("Restore");
        this.restoreButton.setPreferredSize(this.BUTTON_SIZE);
        this.discardButton = new JButton("Discard");
        this.discardButton.setPreferredSize(this.BUTTON_SIZE);
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(10, 20, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        JLabel dataSetNameLabel = new JLabel("<html>It seems that Chipster crashed " + new Date(sessionFile.lastModified()) + ".<br>Do you want to restore the data you were working on?</html>");
        contentPane.add((Component)dataSetNameLabel, c);
        c.gridy = 1;
        c.gridwidth = 1;
        contentPane.add((Component)this.restoreButton, c);
        c.gridx = 1;
        contentPane.add((Component)this.discardButton, c);
        this.setContentPane(contentPane);
        this.restoreButton.addActionListener(this);
        this.discardButton.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.restoreButton) {
            this.client.restoreSessionFrom(this.sessionFile);
        } else {
            this.client.clearDeadTempDirectories();
        }
        this.dispose();
    }
}

