/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.shell;

import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.OnDiskAnalysisJobBase;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public abstract class ShellAnalysisJobBase
extends OnDiskAnalysisJobBase {
    protected static final String SHELL_STRING_SEPARATOR = "\"";
    protected String[] command;
    protected Boolean useStdout = false;
    static final Logger logger = Logger.getLogger(ShellAnalysisJobBase.class);
    private CountDownLatch latch = new CountDownLatch(1);
    private Process process = null;

    @Override
    protected void preExecute() throws JobCancelledException {
        super.preExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws JobCancelledException {
        block6: {
            try {
                String commandString = "";
                for (String s : this.command) {
                    commandString = commandString + s + " ";
                }
                commandString = commandString.trim();
                logger.info((Object)("running shell job: " + commandString));
                this.process = Runtime.getRuntime().exec(this.command, null, this.jobWorkDir);
                this.updateStateDetailToClient("running analysis tool");
                new Thread(new ProcessWaiter()).start();
                this.latch.await();
                this.cancelCheck();
                this.updateStateDetailToClient("analysis tool finished");
                String stdOutString = Files.inputStreamToString(this.process.getInputStream());
                String stdErrorString = Files.inputStreamToString(this.process.getErrorStream());
                this.outputMessage.setOutputText(stdOutString + "\n" + stdErrorString);
                if (this.process.exitValue() != 0) {
                    this.outputMessage.setErrorMessage("Running analysis tool failed.");
                    this.updateState(JobState.FAILED, "non zero exit value");
                    return;
                }
                if (!this.useStdout.booleanValue()) break block6;
                ToolDescription.OutputDescription output = this.analysis.getOutputFiles().get(0);
                File outputFile = new File(this.jobWorkDir, output.getFileName().getID());
                FileOutputStream fileStream = null;
                try {
                    fileStream = new FileOutputStream(outputFile);
                    IOUtils.write((String)stdOutString, (OutputStream)fileStream);
                    fileStream.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fileStream);
            }
            catch (Exception e) {
                this.outputMessage.setErrorMessage("Running analysis tool failed.");
                this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
                this.updateState(JobState.ERROR, "analysis tool failed");
                return;
            }
        }
    }

    @Override
    protected void cancelRequested() {
        this.latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanUp() {
        try {
            if (this.process != null) {
                try {
                    this.process.exitValue();
                }
                catch (IllegalThreadStateException itse) {
                    this.process.destroy();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"error when destroying process ", (Throwable)e);
        }
        finally {
            super.cleanUp();
        }
    }

    private class ProcessWaiter
    implements Runnable {
        private ProcessWaiter() {
        }

        @Override
        public void run() {
            try {
                ShellAnalysisJobBase.this.process.waitFor();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                ShellAnalysisJobBase.this.latch.countDown();
            }
        }
    }
}

