/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.java;

import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.ToolDescriptionGenerator;
import fi.csc.microarray.analyser.java.JavaAnalysisJobBase;
import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLGenerator;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JavaAnalysisHandler
implements AnalysisHandler {
    static final Logger logger = Logger.getLogger(JavaAnalysisHandler.class);
    private HashMap<String, String> parameters;

    public JavaAnalysisHandler(HashMap<String, String> parameters) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        this.parameters = parameters;
    }

    @Override
    public AnalysisJob createAnalysisJob(JobMessage message, ToolDescription description, ResultCallback resultHandler) {
        try {
            Class jobClass = (Class)description.getImplementation();
            JavaAnalysisJobBase analysisJob = (JavaAnalysisJobBase)jobClass.newInstance();
            analysisJob.construct(message, description, resultHandler);
            return analysisJob;
        }
        catch (Exception e) {
            throw new RuntimeException("internal error: type " + description.getImplementation().toString() + " could not be instantiated");
        }
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public ToolDescription handle(File moduleDir, String sourceResourceName, Map<String, String> params) throws AnalysisException {
        SADLDescription sadlDescription;
        JavaAnalysisJobBase jobInstance;
        Class<?> jobClass = null;
        try {
            jobClass = Class.forName(sourceResourceName);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("could not load job class: " + sourceResourceName));
            throw new AnalysisException("could not load job class: " + sourceResourceName);
        }
        assert (JavaAnalysisJobBase.class.isAssignableFrom(jobClass));
        try {
            jobInstance = (JavaAnalysisJobBase)jobClass.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)("could not instantiate job: " + sourceResourceName));
            throw new RuntimeException(e);
        }
        try {
            sadlDescription = new ChipsterSADLParser().parse(jobInstance.getSADL(), sourceResourceName);
        }
        catch (SADLParser.ParseException e) {
            throw new AnalysisException(e);
        }
        ToolDescription ad = new ToolDescriptionGenerator().generate(sadlDescription, this);
        SADLGenerator.generate(sadlDescription);
        ad.setSADL(SADLGenerator.generate(sadlDescription));
        ad.setImplementation(jobClass);
        ad.setCommand("java");
        ad.setToolFile(new File(jobClass.getCanonicalName()));
        ad.setSourceCode("Source code for this tool is available within Chipster source code.");
        return ad;
    }

    public boolean supports(String sourceResourceName) {
        Class<?> jobClass = null;
        try {
            jobClass = Class.forName(sourceResourceName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return JavaAnalysisJobBase.class.isAssignableFrom(jobClass);
    }

    @Override
    public boolean isUptodate(ToolDescription description) {
        return true;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }
}

