/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.SynchronousChannel;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PooledExecutor
extends ThreadFactoryUser
implements Executor {
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
    public static final long DEFAULT_KEEPALIVETIME = 60000L;
    protected static Runnable ENDTASK = new Runnable(){

        public void run() {
        }
    };
    protected volatile int maximumPoolSize_ = Integer.MAX_VALUE;
    protected volatile int minimumPoolSize_ = 1;
    protected long keepAliveTime_ = 60000L;
    protected final Channel handOff_;
    protected Object poolLock_ = new Object();
    protected volatile int poolSize_ = 0;
    protected final Map threads_;
    protected BlockedExecutionHandler blockedExecutionHandler_;

    public PooledExecutor() {
        this(new SynchronousChannel(), Integer.MAX_VALUE);
    }

    public PooledExecutor(int n) {
        this(new SynchronousChannel(), n);
    }

    public PooledExecutor(Channel channel) {
        this(channel, Integer.MAX_VALUE);
    }

    public PooledExecutor(Channel channel, int n) {
        this.maximumPoolSize_ = n;
        this.handOff_ = channel;
        this.runWhenBlocked();
        this.threads_ = new HashMap();
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public void setMaximumPoolSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = n;
    }

    public int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public void setMinimumPoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = n;
    }

    public int getPoolSize() {
        return this.poolSize_;
    }

    protected void addThread(Runnable runnable) {
        ++this.poolSize_;
        Worker worker = new Worker(runnable);
        Thread thread = this.getThreadFactory().newThread(worker);
        this.threads_.put(worker, thread);
        thread.start();
    }

    public int createThreads(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object object = this.poolLock_;
            synchronized (object) {
                if (this.getPoolSize() < this.getMaximumPoolSize()) {
                    ++n2;
                } else {
                    break;
                }
                this.addThread(null);
            }
            ++n3;
        }
        return n2;
    }

    public void interruptAll() {
        Object object = this.poolLock_;
        synchronized (object) {
            Iterator iterator = this.threads_.values().iterator();
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                thread.interrupt();
            }
        }
    }

    public void shutdownAfterProcessingCurrentlyQueuedTasks() {
        Object object = this.poolLock_;
        synchronized (object) {
            if (this.poolSize_ == 0) {
                this.maximumPoolSize_ = 0;
                this.minimumPoolSize_ = 0;
                return;
            }
        }
        try {
            this.handOff_.put(ENDTASK);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public List drain() {
        boolean bl = false;
        Vector<Object> vector = new Vector<Object>();
        while (true) {
            try {
                Object object;
                while ((object = this.handOff_.poll(0L)) != null) {
                    vector.addElement(object);
                }
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return vector;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long l) {
        this.keepAliveTime_ = l;
    }

    protected void workerDone(Worker worker) {
        Object object = this.poolLock_;
        synchronized (object) {
            --this.poolSize_;
            this.threads_.remove(worker);
        }
    }

    protected Runnable getTask() throws InterruptedException {
        long l = this.getKeepAliveTime();
        if (l >= 0L) {
            return (Runnable)this.handOff_.poll(l);
        }
        return (Runnable)this.handOff_.take();
    }

    protected synchronized BlockedExecutionHandler getBlockedExecutionHandler() {
        return this.blockedExecutionHandler_;
    }

    public synchronized void runWhenBlocked() {
        this.blockedExecutionHandler_ = new RunWhenBlocked();
    }

    public synchronized void waitWhenBlocked() {
        this.blockedExecutionHandler_ = new WaitWhenBlocked();
    }

    public synchronized void discardWhenBlocked() {
        this.blockedExecutionHandler_ = new DiscardWhenBlocked();
    }

    public synchronized void discardOldestWhenBlocked() {
        this.blockedExecutionHandler_ = new DiscardOldestWhenBlocked();
    }

    public void execute(Runnable runnable) throws InterruptedException {
        do {
            Object object = this.poolLock_;
            synchronized (object) {
                if (this.getPoolSize() < this.getMinimumPoolSize()) {
                    this.addThread(runnable);
                    return;
                }
                if (this.handOff_.offer(runnable, 0L)) {
                    return;
                }
                if (this.getPoolSize() < this.getMaximumPoolSize()) {
                    this.addThread(runnable);
                    return;
                }
            }
        } while (!this.getBlockedExecutionHandler().blockedAction(runnable));
    }

    protected class DiscardOldestWhenBlocked
    implements BlockedExecutionHandler {
        protected DiscardOldestWhenBlocked() {
        }

        public boolean blockedAction(Runnable runnable) {
            try {
                PooledExecutor.this.handOff_.poll(0L);
                if (!PooledExecutor.this.handOff_.offer(runnable, 0L)) {
                    runnable.run();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    protected class DiscardWhenBlocked
    implements BlockedExecutionHandler {
        protected DiscardWhenBlocked() {
        }

        public boolean blockedAction(Runnable runnable) {
            return true;
        }
    }

    protected class WaitWhenBlocked
    implements BlockedExecutionHandler {
        protected WaitWhenBlocked() {
        }

        public boolean blockedAction(Runnable runnable) {
            try {
                PooledExecutor.this.handOff_.put(runnable);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    protected class RunWhenBlocked
    implements BlockedExecutionHandler {
        protected RunWhenBlocked() {
        }

        public boolean blockedAction(Runnable runnable) {
            runnable.run();
            return true;
        }
    }

    protected static interface BlockedExecutionHandler {
        public boolean blockedAction(Runnable var1);
    }

    protected class Worker
    implements Runnable {
        protected Runnable firstTask_;

        Worker(Runnable runnable) {
            this.firstTask_ = runnable;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    Runnable runnable = this.firstTask_;
                    if (runnable != null) {
                        runnable.run();
                        this.firstTask_ = null;
                        runnable = null;
                    }
                    while (PooledExecutor.this.getPoolSize() <= PooledExecutor.this.getMaximumPoolSize()) {
                        runnable = PooledExecutor.this.getTask();
                        if (runnable == ENDTASK) {
                            PooledExecutor.this.minimumPoolSize_ = 0;
                            PooledExecutor.this.maximumPoolSize_ = 0;
                            PooledExecutor.this.interruptAll();
                        } else if (runnable != null) {
                            runnable.run();
                            runnable = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object var3_4 = null;
                    PooledExecutor.this.workerDone(this);
                    return;
                }
                Object var3_3 = null;
                PooledExecutor.this.workerDone(this);
                return;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                PooledExecutor.this.workerDone(this);
                throw throwable;
            }
        }
    }
}

