/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducerCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingSlip
extends ServiceSupport
implements AsyncProcessor,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(RoutingSlip.class);
    private ProducerCache producerCache;
    private boolean ignoreInvalidEndpoints;
    private String header;
    private Expression expression;
    private String uriDelimiter;
    private final CamelContext camelContext;

    public RoutingSlip(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Deprecated
    public RoutingSlip(CamelContext camelContext, String header) {
        this(camelContext, header, ",");
    }

    @Deprecated
    public RoutingSlip(CamelContext camelContext, String header, String uriDelimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(header, "header");
        ObjectHelper.notNull(uriDelimiter, "uriDelimiter");
        this.camelContext = camelContext;
        this.header = header;
        this.expression = ExpressionBuilder.headerExpression(header);
        this.uriDelimiter = uriDelimiter;
    }

    public RoutingSlip(CamelContext camelContext, Expression expression, String uriDelimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(expression, "expression");
        this.camelContext = camelContext;
        this.expression = expression;
        this.uriDelimiter = uriDelimiter;
        this.header = null;
    }

    public void setDelimiter(String delimiter) {
        this.uriDelimiter = delimiter;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public String toString() {
        return "RoutingSlip[expression=" + this.expression + " uriDelimiter=" + this.uriDelimiter + "]";
    }

    @Override
    public String getTraceLabel() {
        return "routingSlip[" + this.expression + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            throw new IllegalStateException("RoutingSlip has not been started: " + this);
        }
        Object routingSlip = this.expression.evaluate(exchange, Object.class);
        return this.doRoutingSlip(exchange, routingSlip, callback);
    }

    public boolean doRoutingSlip(Exchange exchange, Object routingSlip, AsyncCallback callback) {
        Iterator<Object> iter = ObjectHelper.createIterator(routingSlip, this.uriDelimiter);
        Exchange current = exchange;
        while (iter.hasNext()) {
            FailedToCreateProducerException e;
            Endpoint endpoint;
            try {
                endpoint = this.resolveEndpoint(iter, exchange);
                if (endpoint == null) {
                    continue;
                }
            }
            catch (Exception e2) {
                exchange.setException(e2);
                return true;
            }
            Exchange copy = this.prepareExchangeForRoutingSlip(current);
            boolean sync = this.processExchange(endpoint, copy, exchange, callback, iter);
            current = copy;
            if (!sync) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed asynchronously"));
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed synchronously"));
            }
            if (this.isIgnoreInvalidEndpoints() && (e = current.getException(FailedToCreateProducerException.class)) != null) {
                LOG.info((Object)("Endpoint uri is invalid: " + endpoint + ". This exception will be ignored."), (Throwable)e);
                current.setException(null);
            }
            boolean exceptionHandled = RoutingSlip.hasExceptionBeenHandledByErrorHandler(current);
            if (!current.isFailed() && !current.isRollbackOnly() && !exceptionHandled) continue;
            if (!LOG.isDebugEnabled()) break;
            StringBuilder sb = new StringBuilder();
            sb.append("Message exchange has failed so breaking out of the routing slip: ").append(current);
            if (current.isRollbackOnly()) {
                sb.append(" Marked as rollback only.");
            }
            if (current.getException() != null) {
                sb.append(" Exception: ").append(current.getException());
            }
            if (current.hasOut() && current.getOut().isFault()) {
                sb.append(" Fault: ").append(current.getOut());
            }
            if (exceptionHandled) {
                sb.append(" Handled by the error handler.");
            }
            LOG.debug((Object)sb.toString());
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing complete for exchangeId: " + exchange.getExchangeId() + " >>> " + current));
        }
        ExchangeHelper.copyResults(exchange, current);
        callback.done(true);
        return true;
    }

    protected Endpoint resolveEndpoint(Iterator<Object> iter, Exchange exchange) throws Exception {
        Object nextRecipient = iter.next();
        Endpoint endpoint = null;
        try {
            endpoint = ExchangeHelper.resolveEndpoint(exchange, nextRecipient);
        }
        catch (Exception e) {
            if (this.isIgnoreInvalidEndpoints()) {
                LOG.info((Object)("Endpoint uri is invalid: " + nextRecipient + ". This exception will be ignored."), (Throwable)e);
            }
            throw e;
        }
        return endpoint;
    }

    protected Exchange prepareExchangeForRoutingSlip(Exchange current) {
        DefaultExchange copy = new DefaultExchange(current);
        copy.setExchangeId(current.getExchangeId());
        this.updateRoutingSlipHeader(current);
        this.copyOutToIn(copy, current);
        return copy;
    }

    protected boolean processExchange(final Endpoint endpoint, Exchange exchange, final Exchange original, AsyncCallback callback, final Iterator<Object> iter) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " >>> " + exchange));
        }
        boolean sync = this.producerCache.doInAsyncProducer(endpoint, exchange, null, callback, new AsyncProducerCallback(){

            public boolean doInAsyncProducer(Producer producer, AsyncProcessor asyncProducer, final Exchange exchange, ExchangePattern exchangePattern, final AsyncCallback callback) {
                exchange.setProperty("CamelToEndpoint", producer.getEndpoint().getEndpointUri());
                boolean sync = AsyncProcessorHelper.process(asyncProducer, exchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                        if (doneSync) {
                            return;
                        }
                        Exchange current = exchange;
                        while (iter.hasNext()) {
                            Endpoint endpoint;
                            FailedToCreateProducerException e;
                            if (RoutingSlip.this.isIgnoreInvalidEndpoints() && (e = current.getException(FailedToCreateProducerException.class)) != null) {
                                LOG.info((Object)("Endpoint uri is invalid: " + endpoint + ". This exception will be ignored."), (Throwable)e);
                                current.setException(null);
                            }
                            boolean exceptionHandled = RoutingSlip.hasExceptionBeenHandledByErrorHandler(current);
                            if (current.isFailed() || current.isRollbackOnly() || exceptionHandled) {
                                if (!LOG.isDebugEnabled()) break;
                                StringBuilder sb = new StringBuilder();
                                sb.append("Message exchange has failed so breaking out of the routing slip: ").append(current);
                                if (current.isRollbackOnly()) {
                                    sb.append(" Marked as rollback only.");
                                }
                                if (current.getException() != null) {
                                    sb.append(" Exception: ").append(current.getException());
                                }
                                if (current.hasOut() && current.getOut().isFault()) {
                                    sb.append(" Fault: ").append(current.getOut());
                                }
                                if (exceptionHandled) {
                                    sb.append(" Handled by the error handler.");
                                }
                                LOG.debug((Object)sb.toString());
                                break;
                            }
                            try {
                                endpoint = RoutingSlip.this.resolveEndpoint(iter, exchange);
                                if (endpoint == null) {
                                    continue;
                                }
                            }
                            catch (Exception e2) {
                                exchange.setException(e2);
                                break;
                            }
                            Exchange copy = RoutingSlip.this.prepareExchangeForRoutingSlip(current);
                            boolean sync = RoutingSlip.this.processExchange(endpoint, copy, original, callback, iter);
                            current = copy;
                            if (sync) continue;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)("Processing exchangeId: " + original.getExchangeId() + " is continued being processed asynchronously"));
                            }
                            return;
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Processing complete for exchangeId: " + original.getExchangeId() + " >>> " + current));
                        }
                        ExchangeHelper.copyResults(original, current);
                        callback.done(false);
                    }
                });
                return sync;
            }
        });
        return sync;
    }

    private static boolean hasExceptionBeenHandledByErrorHandler(Exchange nextExchange) {
        return Boolean.TRUE.equals(nextExchange.getProperty("CamelErrorHandlerHandled"));
    }

    @Override
    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(this, this.camelContext);
            this.camelContext.addService(this.producerCache);
        }
        ServiceHelper.startService(this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producerCache);
    }

    private void updateRoutingSlipHeader(Exchange current) {
        Message message;
        String oldSlip;
        if (this.header != null && (oldSlip = (message = this.getResultMessage(current)).getHeader(this.header, String.class)) != null) {
            int delimiterIndex = oldSlip.indexOf(this.uriDelimiter);
            String newSlip = delimiterIndex > 0 ? oldSlip.substring(delimiterIndex + 1) : "";
            message.setHeader(this.header, newSlip);
        }
    }

    private Message getResultMessage(Exchange exchange) {
        if (exchange.hasOut()) {
            return exchange.getOut();
        }
        return exchange.getIn();
    }

    private void copyOutToIn(Exchange result, Exchange source) {
        result.setException(source.getException());
        if (source.hasOut() && source.getOut().isFault()) {
            result.getOut().copyFrom(source.getOut());
        }
        result.setIn(this.getResultMessage(source));
        result.getProperties().clear();
        result.getProperties().putAll(source.getProperties());
    }
}

