/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.processor.PollEnricher;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="pollEnrich")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PollEnrichDefinition
extends OutputDefinition<PollEnrichDefinition> {
    @XmlAttribute(name="uri")
    private String resourceUri;
    @XmlAttribute(name="ref")
    private String resourceRef;
    @XmlAttribute(name="timeout")
    private Long timeout;
    @XmlAttribute(name="strategyRef")
    private String aggregationStrategyRef;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;

    public PollEnrichDefinition() {
        this(null, null, 0L);
    }

    public PollEnrichDefinition(AggregationStrategy aggregationStrategy, String resourceUri, long timeout) {
        this.aggregationStrategy = aggregationStrategy;
        this.resourceUri = resourceUri;
        this.timeout = timeout;
    }

    public String toString() {
        return "PollEnrich[" + (this.resourceUri != null ? this.resourceUri : "ref:" + this.resourceRef) + " " + this.aggregationStrategy + "]";
    }

    @Override
    public String getShortName() {
        return "pollEnrich";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (ObjectHelper.isEmpty(this.resourceUri) && ObjectHelper.isEmpty(this.resourceRef)) {
            throw new IllegalArgumentException("Either uri or ref must be provided for resource endpoint");
        }
        Endpoint endpoint = this.resourceUri != null ? routeContext.resolveEndpoint(this.resourceUri) : routeContext.resolveEndpoint(null, this.resourceRef);
        PollEnricher enricher = this.timeout != null ? new PollEnricher(null, endpoint.createPollingConsumer(), this.timeout) : new PollEnricher(null, endpoint.createPollingConsumer(), 0L);
        if (this.aggregationStrategyRef != null) {
            this.aggregationStrategy = routeContext.lookup(this.aggregationStrategyRef, AggregationStrategy.class);
        }
        if (this.aggregationStrategy == null) {
            enricher.setDefaultAggregationStrategy();
        } else {
            enricher.setAggregationStrategy(this.aggregationStrategy);
        }
        return enricher;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    public String getResourceRef() {
        return this.resourceRef;
    }

    public void setResourceRef(String resourceRef) {
        this.resourceRef = resourceRef;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getAggregationStrategyRef() {
        return this.aggregationStrategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.aggregationStrategyRef = aggregationStrategyRef;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }
}

