/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.spi.ManagementStrategy;
import org.fusesource.commons.management.Statistic;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed Counter")
public abstract class ManagedCounter {
    protected Statistic exchangesTotal;

    public void init(ManagementStrategy strategy) {
        this.exchangesTotal = strategy.createStatistic("org.apache.camel.exchangesTotal", this, Statistic.UpdateMode.COUNTER);
    }

    @ManagedOperation(description="Reset counters")
    public synchronized void reset() {
        this.exchangesTotal.reset();
    }

    @ManagedAttribute(description="Total number of exchanges")
    public long getExchangesTotal() throws Exception {
        return this.exchangesTotal.getValue();
    }

    public synchronized void increment() {
        this.exchangesTotal.increment();
    }
}

