/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.management.mbean.ManagedService;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed Consumer")
public class ManagedConsumer
extends ManagedService {
    private final Consumer consumer;

    public ManagedConsumer(CamelContext context, Consumer consumer) {
        super(context, consumer);
        this.consumer = consumer;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    @ManagedAttribute(description="Endpoint Uri")
    public String getEndpointUri() {
        return this.consumer.getEndpoint().getEndpointUri();
    }

    @ManagedAttribute(description="Current number of inflight Exchanges")
    public Integer getInflightExchanges() {
        return this.getContext().getInflightRepository().size(this.consumer.getEndpoint());
    }
}

