/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;

public class DefaultManagementAgent
extends ServiceSupport
implements ManagementAgent,
CamelContextAware {
    public static final String DEFAULT_DOMAIN = "org.apache.camel";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_REGISTRY_PORT = 1099;
    public static final int DEFAULT_CONNECTION_PORT = -1;
    public static final String DEFAULT_SERVICE_URL_PATH = "/jmxrmi/camel";
    private static final transient Log LOG = LogFactory.getLog(DefaultManagementAgent.class);
    private CamelContext camelContext;
    private ExecutorService executorService;
    private MBeanServer server;
    private final Set<ObjectName> mbeansRegistered = new HashSet<ObjectName>();
    private MetadataMBeanInfoAssembler assembler;
    private JMXConnectorServer cs;
    private Integer registryPort;
    private Integer connectorPort;
    private String mBeanServerDefaultDomain;
    private String mBeanObjectDomainName;
    private String serviceUrlPath;
    private Boolean usePlatformMBeanServer = true;
    private Boolean createConnector;
    private Boolean onlyRegisterProcessorWithCustomId;

    public DefaultManagementAgent() {
    }

    public DefaultManagementAgent(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void finalizeSettings() {
        if (this.registryPort == null) {
            this.registryPort = Integer.getInteger("org.apache.camel.jmx.rmiConnector.registryPort", 1099);
        }
        if (this.connectorPort == null) {
            this.connectorPort = Integer.getInteger("org.apache.camel.jmx.rmiConnector.connectorPort", -1);
        }
        if (this.mBeanServerDefaultDomain == null) {
            this.mBeanServerDefaultDomain = System.getProperty("org.apache.camel.jmx.mbeanServerDefaultDomain", DEFAULT_DOMAIN);
        }
        if (this.mBeanObjectDomainName == null) {
            this.mBeanObjectDomainName = System.getProperty("org.apache.camel.jmx.mbeanObjectDomainName", DEFAULT_DOMAIN);
        }
        if (this.serviceUrlPath == null) {
            this.serviceUrlPath = System.getProperty("org.apache.camel.jmx.serviceUrlPath", DEFAULT_SERVICE_URL_PATH);
        }
        if (this.createConnector == null) {
            this.createConnector = Boolean.getBoolean("org.apache.camel.jmx.createRmiConnector");
        }
        if (System.getProperty("org.apache.camel.jmx.usePlatformMBeanServer") != null) {
            this.usePlatformMBeanServer = Boolean.getBoolean("org.apache.camel.jmx.usePlatformMBeanServer");
        }
        if (this.onlyRegisterProcessorWithCustomId == null) {
            this.onlyRegisterProcessorWithCustomId = Boolean.getBoolean("org.apache.camel.jmx.onlyRegisterProcessorWithCustomId");
        }
    }

    public void setRegistryPort(Integer value) {
        this.registryPort = value;
    }

    public Integer getRegistryPort() {
        return this.registryPort;
    }

    public void setConnectorPort(Integer value) {
        this.connectorPort = value;
    }

    public Integer getConnectorPort() {
        return this.connectorPort;
    }

    public void setMBeanServerDefaultDomain(String value) {
        this.mBeanServerDefaultDomain = value;
    }

    public String getMBeanServerDefaultDomain() {
        return this.mBeanServerDefaultDomain;
    }

    public void setMBeanObjectDomainName(String value) {
        this.mBeanObjectDomainName = value;
    }

    public String getMBeanObjectDomainName() {
        return this.mBeanObjectDomainName;
    }

    public void setServiceUrlPath(String value) {
        this.serviceUrlPath = value;
    }

    public String getServiceUrlPath() {
        return this.serviceUrlPath;
    }

    public void setCreateConnector(Boolean flag) {
        this.createConnector = flag;
    }

    public Boolean getCreateConnector() {
        return this.createConnector;
    }

    public void setUsePlatformMBeanServer(Boolean flag) {
        this.usePlatformMBeanServer = flag;
    }

    public Boolean getUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    public Boolean getOnlyRegisterProcessorWithCustomId() {
        return this.onlyRegisterProcessorWithCustomId;
    }

    public void setOnlyRegisterProcessorWithCustomId(Boolean onlyRegisterProcessorWithCustomId) {
        this.onlyRegisterProcessorWithCustomId = onlyRegisterProcessorWithCustomId;
    }

    public void setMBeanServer(MBeanServer mbeanServer) {
        this.server = mbeanServer;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        try {
            this.registerMBeanWithServer(obj, name, forceRegistration);
        }
        catch (NotCompliantMBeanException e) {
            ModelMBeanInfo mbi = this.assembler.getMBeanInfo(obj, name.toString());
            RequiredModelMBean mbean = (RequiredModelMBean)this.server.instantiate(RequiredModelMBean.class.getName());
            mbean.setModelMBeanInfo(mbi);
            try {
                mbean.setManagedResource(obj, "ObjectReference");
            }
            catch (InvalidTargetObjectTypeException itotex) {
                throw new JMException(itotex.getMessage());
            }
            this.registerMBeanWithServer(mbean, name, forceRegistration);
        }
    }

    public void unregister(ObjectName name) throws JMException {
        this.server.unregisterMBean(name);
        this.mbeansRegistered.remove(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unregistered MBean with objectname: " + name));
        }
    }

    public boolean isRegistered(ObjectName name) {
        return this.server.isRegistered(name);
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        this.assembler = new MetadataMBeanInfoAssembler();
        this.assembler.setAttributeSource((JmxAttributeSource)new AnnotationJmxAttributeSource());
        if (this.server == null) {
            this.finalizeSettings();
            this.createMBeanServer();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting JMX agent on server: " + this.getMBeanServer()));
        }
    }

    protected void doStop() throws Exception {
        if (this.cs != null) {
            try {
                this.cs.stop();
            }
            catch (IOException e) {
                LOG.debug((Object)("Error occurred during stopping JMXConnectorService: " + this.cs + ". This exception will be ignored."));
            }
            this.cs = null;
        }
        if (this.mbeansRegistered.isEmpty()) {
            return;
        }
        ObjectName[] mBeans = this.mbeansRegistered.toArray(new ObjectName[this.mbeansRegistered.size()]);
        int caught = 0;
        for (ObjectName name : mBeans) {
            try {
                this.mbeansRegistered.remove(name);
                this.unregister(name);
            }
            catch (Exception e) {
                LOG.info((Object)("Exception unregistering MBean with name " + name), (Throwable)e);
                ++caught;
            }
        }
        if (caught > 0) {
            LOG.warn((Object)("A number of " + caught + " exceptions caught while unregistering MBeans during stop operation." + " See INFO log for details."));
        }
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        boolean exists = this.server.isRegistered(name);
        if (exists) {
            if (forceRegistration) {
                LOG.info((Object)"ForceRegistration enabled, unregistering existing MBean");
                this.server.unregisterMBean(name);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("MBean already registered with objectname: " + name));
            }
        }
        ObjectInstance instance = null;
        if (forceRegistration || !exists) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Registering MBean with objectname: " + name));
            }
            instance = this.server.registerMBean(obj, name);
        }
        if (instance != null) {
            ObjectName registeredName = instance.getObjectName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Registered MBean with objectname: " + registeredName));
            }
            this.mbeansRegistered.add(registeredName);
        }
    }

    protected void createMBeanServer() {
        String hostName;
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                LOG.info((Object)"Cannot determine localhost name. Using default: 1099", (Throwable)uhe);
                hostName = DEFAULT_HOST;
            }
        } else {
            hostName = DEFAULT_HOST;
        }
        this.server = this.findOrCreateMBeanServer();
        try {
            if (this.createConnector.booleanValue()) {
                this.createJmxConnector(hostName);
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Could not create and start JMX connector.", (Throwable)ioe);
        }
    }

    protected MBeanServer findOrCreateMBeanServer() {
        if (this.usePlatformMBeanServer.booleanValue()) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found MBeanServer with default domain " + server.getDefaultDomain()));
            }
            if (!this.mBeanServerDefaultDomain.equals(server.getDefaultDomain())) continue;
            return server;
        }
        return MBeanServerFactory.createMBeanServer(this.mBeanServerDefaultDomain);
    }

    protected void createJmxConnector(String host) throws IOException {
        ObjectHelper.notEmpty(this.serviceUrlPath, "serviceUrlPath");
        ObjectHelper.notNull(this.registryPort, "registryPort");
        try {
            LocateRegistry.createRegistry(this.registryPort);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created JMXConnector RMI registry on port " + this.registryPort));
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        String path = this.serviceUrlPath.startsWith("/") ? this.serviceUrlPath : "/" + this.serviceUrlPath;
        JMXServiceURL url = this.connectorPort > 0 ? new JMXServiceURL("service:jmx:rmi://" + host + ":" + this.connectorPort + "/jndi/rmi://" + host + ":" + this.registryPort + path) : new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + this.registryPort + path);
        this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.server);
        if (this.executorService == null) {
            this.executorService = this.camelContext.getExecutorServiceStrategy().newSingleThreadExecutor(this, "JMXConnector: " + url);
        }
        this.executorService.execute(new Runnable(){

            public void run() {
                try {
                    DefaultManagementAgent.this.cs.start();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Could not start JMXConnector thread.", (Throwable)ioe);
                }
            }
        });
        LOG.info((Object)("JMX Connector thread started and listening at: " + url));
    }
}

