/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.InflightRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultInflightRepository
extends ServiceSupport
implements InflightRepository {
    private static final transient Log LOG = LogFactory.getLog(DefaultInflightRepository.class);
    private final AtomicInteger totalCount = new AtomicInteger();
    private final ConcurrentHashMap<String, AtomicInteger> endpointCount = new ConcurrentHashMap();

    public void add(Exchange exchange) {
        int count = this.totalCount.incrementAndGet();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Total " + count + " inflight exchanges. Last added: " + exchange.getExchangeId()));
        }
        if (exchange.getFromEndpoint() == null) {
            return;
        }
        String key = exchange.getFromEndpoint().getEndpointKey();
        AtomicInteger existing = this.endpointCount.putIfAbsent(key, new AtomicInteger(1));
        if (existing != null) {
            existing.addAndGet(1);
        }
    }

    public void remove(Exchange exchange) {
        int count = this.totalCount.decrementAndGet();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Total " + count + " inflight exchanges. Last removed: " + exchange.getExchangeId()));
        }
        if (exchange.getFromEndpoint() == null) {
            return;
        }
        String key = exchange.getFromEndpoint().getEndpointKey();
        AtomicInteger existing = this.endpointCount.get(key);
        if (existing != null) {
            existing.addAndGet(-1);
        }
    }

    public int size() {
        return this.totalCount.get();
    }

    public int size(Endpoint endpoint) {
        AtomicInteger answer = this.endpointCount.get(endpoint.getEndpointKey());
        return answer != null ? answer.get() : 0;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        int count = this.size();
        if (count > 0) {
            LOG.warn((Object)("Shutting down while there are still " + count + " in flight exchanges."));
        } else {
            LOG.info((Object)"Shutting down with no inflight exchanges.");
        }
        this.endpointCount.clear();
    }
}

