package org.jfree.chart.plot.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.AssertionFailedError;

import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.chart.plot.StandardHCClusteringInfo;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.data.hc.DataRange;

import java.util.List;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


/**
 * Tests for the {@link org.jfree.chart.plot.StandardHCClusteringInfo} class.
 */

public class StandardHCClusteringInfoTests extends TestCase 
                                           implements ChangeListener {

    private HCTreeNode rootnode;
    private HCTreeNode leftnode;
    private HCTreeNode rightnode;
    private String[] names;
    private int location;
    private ChangeEvent e;

   /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(StandardHCClusteringInfoTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public StandardHCClusteringInfoTests(String name)
           throws Exception {

        super(name);

        this.rootnode = new HCTreeNode(1.0);
        this.leftnode = new HCTreeNode(1.0, 0);
        this.rightnode = new HCTreeNode(1.0, 1);
        this.names = new String[] {"names1","names2"};
        this.location = 1;
        this.e = null;

        try {
            this.rootnode.setRightChild(rightnode);
            this.rootnode.setLeftChild(leftnode);
        } catch (Exception e) {}

    }
    /**
     * Tests for the constructor
     *
     */
    public void testConstructor() {
        String s1 = "You must create a DummyHCClusteringInfo if you do not have " +
		    "a root node.";
        String s2 = "location must be LEFT or RIGHT.";

        try {
            new StandardHCClusteringInfo(
                null, this.names, this.location);
            assertTrue(false);
        } catch (NullPointerException e) {
            assertTrue(s1.equals(e.getMessage()));
        }

        try {
            new StandardHCClusteringInfo(
                this.rootnode, this.names, -1);
            assertTrue(false);
        } catch (IllegalArgumentException e) {
            assertTrue(s2.equals(e.getMessage()));
        }

        try {
            new StandardHCClusteringInfo(
                this.rootnode, this.names, 2);
            assertTrue(false);
        } catch (IllegalArgumentException e) {
            assertTrue(s2.equals(e.getMessage()));
        }

        assertNotNull(new StandardHCClusteringInfo(
                this.rootnode, this.names, this.location));
        assertNotNull(new StandardHCClusteringInfo(
                this.rootnode, null, this.location));

    }
    /**
     * Checking methods
     */

    public void testMethods() {
       StandardHCClusteringInfo stinfo = new StandardHCClusteringInfo(
           this.rootnode, this.names, this.location);

       assertNotNull(stinfo.getRootNode());
       assertTrue(2 == stinfo.getNumberOfVisibleItems());

       List namelist = stinfo.getNames();
       assertNotNull(namelist);

       assertTrue(stinfo.getDataRangeForVisibleIndex(0).equals(new DataRange(0,0)));
       assertTrue(stinfo.getDataRangeForVisibleIndex(1).equals(new DataRange(1,1)));
       try {
            stinfo.getDataRangeForVisibleIndex(-1);
            assertTrue(false);
       } catch (Exception  e) {}
       try {
            stinfo.getDataRangeForVisibleIndex(2);
            assertTrue(false);
       } catch (Exception  e) {}

    }

    /**
     * Tests for listener methods that HCClusteringInfo
     * inherits from AbstractHCClusteringInfo.
     *
     */
    public void testEvents() {
    
       StandardHCClusteringInfo stinfo = 
           new StandardHCClusteringInfo(
               this.rootnode, this.names, this.location);

       //try to notify a listener that doesn't exist
       try {
           stinfo.notifyChangeListeners(new ChangeEvent(this));
           assertTrue(false);
       } catch (junit.framework.AssertionFailedError e) {
       }

       //test methods properly
       stinfo.addChangeListener(this);
       stinfo.notifyChangeListeners(new ChangeEvent(this));
       assertEquals(this, this.e.getSource());
       stinfo.removeChangeListener(this);

       //try to notify a listener that doesn't exist anymore
       try {
           stinfo.notifyChangeListeners(new ChangeEvent(this));
           assertTrue(false);
       } catch (junit.framework.AssertionFailedError e) {
       }
       
       //null parameter
       stinfo.addChangeListener(null);
       stinfo.addChangeListener(this);
       stinfo.addChangeListener(null);
       try {
           stinfo.notifyChangeListeners(new ChangeEvent(this));
       }catch (Exception e) { 
           //empty listener list
       }
       stinfo.addChangeListener(this);
       stinfo.removeChangeListener(null);
       try {
           stinfo.notifyChangeListeners(null);
           assertTrue(false);
       } catch (Exception e) {
         //null source
       }

   }
    /**
    * Implements the ChangeListener interface.
    *
    * @param e  a ChangeEvent object
    */
    public void stateChanged(ChangeEvent e) {
        this.e = e;
    }

     /**
     * Runs the test suite using JUnit's text-based runner.
     *
     * @param args  ignored.
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }


}