/* =======================================================================
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */


package org.jfree.chart;

import java.awt.Color;
import java.awt.Font;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;

import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.chart.labels.StandardSOMToolTipGenerator;
import org.jfree.chart.labels.StandardHCToolTipGenerator;
import org.jfree.chart.plot.SOMPlot;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.som.SOMDataset;
import org.jfree.data.hc.HCDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.SortOrder;
import org.jfree.util.TableOrder;

/**
 * A collection of utility methods for creating some standard charts with 
 * JFreeChart.
 */
public class BioChartFactory {
    

    /**
     * Creates a hierarchical clustering and heatmap chart
     * 
     * @param title  the chart title (<code>null</code> permitted).
     * @param dataset  the dataset for the chart (<code>null</code> permitted).
     * @param tooltips  configure chart to generate tool tips.
     * @param urls  configure chart to generate URLs.
     * 
     * @return  A Hierarchical clustering and heatmap chart.
     */
    public static JFreeChart createHCChart(String title, 
                                           HCDataset dataset,
                                           boolean tooltips,
                                           boolean urls) {
        HCPlot plot = new HCPlot(dataset);
        
        if (tooltips) {
            plot.setToolTipGenerator(
                new StandardHCToolTipGenerator()
            );
        }
//        if (urls) {
//            plot.setURLGenerator(new StandardPieURLGenerator());
//        }
        JFreeChart chart = new JFreeChart(
            title, JFreeChart.DEFAULT_TITLE_FONT, plot, false
        );
	chart.setAntiAlias(false);

        return chart;
    }
    
    /**
     * Creates a som-map chart with default settings.
     * 
     * @param title  the chart title (<code>null</code> permitted).
     * @param dataset  the dataset for the chart (<code>null</code> permitted).
     * @param tooltips  configure chart to generate tool tips.
     * @param urls  configure chart to generate URLs.
     * 
     * @return  A SOM-map chart.
     */
    public static JFreeChart createSOMChart(String title, 
                                            SOMDataset dataset,
                                            boolean tooltips,
                                            boolean urls) {
        SOMPlot plot = new SOMPlot(dataset);
        
        if (tooltips) {
            plot.setToolTipGenerator(
                new StandardSOMToolTipGenerator()
            );
        }
//        if (urls) {
//            plot.setURLGenerator(new StandardPieURLGenerator());
//        }
        return new JFreeChart(
            title, JFreeChart.DEFAULT_TITLE_FONT, plot, false
        );
    }
}
