/*
 * AutomatedMovement.java
 *
 * Created on 3. keskuuta 2006, 20:53
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package threed;

import java.util.*;

/**
 *
 * @author esa
 */
public class AutomatedMovement extends Thread {
    private Projection projection;
    private Worker worker;
    private LinkedList<Task> taskQueue;
    private Object obj;
    
    /**
     * Creates a new instance of AutomatedMovement
     * @param projection 
     * @param worker 
     */
    public AutomatedMovement(Projection projection, Worker worker) {
        this.projection = projection;
        this.worker = worker;
        this.taskQueue = new LinkedList<Task>();
        this.obj = new Object();
    }
    
    /**
     * 
     * @param point 
     * @param time 
     * @param fps 
     */
    public void addTranslationTask (double[] point, long time, double fps) {
        synchronized(obj) {
            taskQueue.addLast(new TranslationTask(point, time, fps));
            obj.notify();
        }
    }
    
    /**
     * 
     * @param xRotation 
     * @param yRotation 
     * @param zRotation 
     * @param time 
     * @param fps 
     */
    public void addRotationTask (double xRotation, double yRotation, double zRotation, 
            long time, double fps) {
        synchronized(obj) {
            taskQueue.addLast(new RotationTask(xRotation, yRotation, zRotation, time, fps));
            obj.notify();
        }
    }
    
    public void run() {
        Task task;
        while (true) {
            synchronized(obj) {
                while (taskQueue.isEmpty()) {
                    try {
                        obj.wait();
                    } catch (InterruptedException e) {}
                }
                task = taskQueue.poll();
                obj.notify();
            }
            task.doTask();
            task = null;
        }
    }
    
    private class Task {
        public void doTask() {
        }
    }
    
    private class TranslationTask extends Task {
        private double[] point;
        private long time;
        private double fps;
        
        public TranslationTask(double[] point, long time, double fps) {
            this.point = point;
            this.time = time;
            this.fps = fps;
        }
        
        public void doTask() {
            double ticks = (time/1000.0)*fps;
            double timeIncrement = 1000.0/fps;
            double[] placeIncrement = new double[3];
            placeIncrement[0] = point[0]/ticks;
            placeIncrement[1] = point[1]/ticks;
            placeIncrement[2] = point[2]/ticks;
            
            for (int i=0; i < ticks; ++i) {
                projection.setNewOrigin(placeIncrement);
                worker.workRequest();
                try {
                    sleep((long)timeIncrement);
                }
                catch (InterruptedException e) {}
            }
           
        }
        
    }
    
    private class RotationTask extends Task {
        private double xRotation;
        private double yRotation;
        private double zRotation;
        private long time;
        private double fps;
        
        public RotationTask(double xRotation, double yRotation, double zRotation, 
                long time, double fps) {
            this.xRotation = xRotation;
            this.yRotation = yRotation;
            this.zRotation = zRotation;
            this.time = time;
            this.fps = fps;
        }
        
        public void doTask() {
            double ticks = (time/1000.0)*fps;
            double timeIncrement = 1000.0/fps;
            double xAngleInc = xRotation/ticks;
            double yAngleInc = yRotation/ticks;
            double zAngleInc = zRotation/ticks;
            
            for (int i=0; i < ticks; ++i) {
                projection.setXAxisRotation(xAngleInc);
                projection.setYAxisRotation(yAngleInc);
                projection.setZAxisRotation(zAngleInc);
                worker.workRequest();
                try {
                    sleep((long)timeIncrement);
                }
                catch (InterruptedException e) {}
            }
           
        }
        
    }
    
}
