package it.sauronsoftware.cron4j;

/**
 * <p>
 * A scheduling patterns validator.
 * </p>
 * 
 * <p>
 * The class lets you validate a scheduling pattern before/without sending it to
 * the schedule()/reschedule() method of a Scheduler instance. Simply call:
 * </p>
 * 
 * <pre>
 * boolean valid = SchedulingPatternValidator.validate(thePattern);
 * </pre>
 * 
 * <p>
 * It is useful in validating user-entered patterns.
 * </p>
 * 
 * @author Carlo Pelliccia
 */
public class SchedulingPatternValidator {

	/**
	 * This method validate a scheduling pattern string.
	 * 
	 * @param schedulingPattern
	 *            The pattern.
	 * @return true if the pattern is valid. It means that it could be used in
	 *         the scheduling of task, calling the schedule() method of a
	 *         Scheduler object, without any trouble: if the pattern is valid no
	 *         InvalidPatternException could be thrown.
	 */
	public static boolean validate(String schedulingPattern) {
		try {
			new SchedulingPattern(schedulingPattern);
		} catch (InvalidPatternException e) {
			return false;
		}
		return true;
	}

}
